/*
 * Decompiled with CFR 0.152.
 */
package net.akaciobahno.backported_animal_variants.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.akaciobahno.backported_animal_variants.entity.ModModelLayers;
import net.akaciobahno.backported_animal_variants.entity.client.CustomSheepModel;
import net.akaciobahno.backported_animal_variants.entity.client.CustomSheepSkinModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class CustomSheepSkinLayer
extends RenderLayer<Sheep, CustomSheepModel<Sheep>> {
    private static final ResourceLocation SHEEP_SKIN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"backported_animal_variants", (String)"textures/entity/custom_sheep_skin.png");
    private final CustomSheepSkinModel<Sheep> model;

    public CustomSheepSkinLayer(RenderLayerParent<Sheep, CustomSheepModel<Sheep>> pRenderer, EntityModelSet pModelSet) {
        super(pRenderer);
        this.model = new CustomSheepSkinModel(pModelSet.bakeLayer(ModModelLayers.CUSTOM_SHEEP_SKIN_LAYER));
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Sheep livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (livingEntity.isInvisible()) {
            Minecraft minecraft = Minecraft.getInstance();
            boolean j = minecraft.shouldEntityAppearGlowing((Entity)livingEntity);
            if (j) {
                ((CustomSheepModel)this.getParentModel()).copyPropertiesTo((EntityModel)this.model);
                this.model.prepareMobModel(livingEntity, limbSwing, limbSwingAmount, partialTicks);
                this.model.setupAnim(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.outline((ResourceLocation)SHEEP_SKIN_LOCATION));
                this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)livingEntity, (float)0.0f), -16777216);
            }
        } else {
            int i;
            if (livingEntity.hasCustomName() && "jeb_".equals(livingEntity.getName().getString())) {
                boolean j = true;
                int k = livingEntity.tickCount / 25 + livingEntity.getId();
                int l = DyeColor.values().length;
                int i1 = k % l;
                int j1 = (k + 1) % l;
                float f = ((float)(livingEntity.tickCount % 25) + partialTicks) / 25.0f;
                int k1 = Sheep.getColor((DyeColor)DyeColor.byId((int)i1));
                int l1 = Sheep.getColor((DyeColor)DyeColor.byId((int)j1));
                i = FastColor.ARGB32.lerp((float)f, (int)k1, (int)l1);
            } else {
                i = Sheep.getColor((DyeColor)livingEntity.getColor());
            }
            CustomSheepSkinLayer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), this.model, (ResourceLocation)SHEEP_SKIN_LOCATION, (PoseStack)poseStack, (MultiBufferSource)buffer, (int)packedLight, (LivingEntity)livingEntity, (float)limbSwing, (float)limbSwingAmount, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)partialTicks, (int)i);
        }
    }
}

