/*
 * Decompiled with CFR 0.152.
 */
package net.akaciobahno.backported_animal_variants.entity.client;

import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.animal.Sheep;

public class CustomSheepModel<T extends Sheep>
extends QuadrupedModel<T> {
    private float headXRot;

    public CustomSheepModel(ModelPart root) {
        super(root, false, 8.0f, 4.0f, 2.0f, 2.0f, 24);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = 12;
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -6.0f, 6.0f, 6.0f, 8.0f), PartPose.offset((float)0.0f, (float)6.0f, (float)-8.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(28, 8).addBox(-6.0f, -10.0f, -7.0f, 8.0f, 16.0f, 6.0f), PartPose.offsetAndRotation((float)2.0f, (float)5.0f, (float)2.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f);
        partdefinition.addOrReplaceChild("right_hind_leg", cubelistbuilder, PartPose.offset((float)-3.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", cubelistbuilder, PartPose.offset((float)3.0f, (float)12.0f, (float)7.0f));
        partdefinition.addOrReplaceChild("right_front_leg", cubelistbuilder, PartPose.offset((float)-3.0f, (float)12.0f, (float)-5.0f));
        partdefinition.addOrReplaceChild("left_front_leg", cubelistbuilder, PartPose.offset((float)3.0f, (float)12.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.prepareMobModel(pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        this.head.y = 6.0f + pEntity.getHeadEatPositionScale(pPartialTick) * 9.0f;
        this.headXRot = pEntity.getHeadEatAngleScale(pPartialTick);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        super.setupAnim(pEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        this.head.xRot = this.headXRot;
    }
}

