/*
 * Decompiled with CFR 0.152.
 */
package net.akaciobahno.backported_animal_variants.entity.client;

import net.akaciobahno.backported_animal_variants.entity.ModModelLayers;
import net.akaciobahno.backported_animal_variants.entity.client.ColdChickenModel;
import net.akaciobahno.backported_animal_variants.entity.custom.ColdChicken;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColdChickenRenderer
extends MobRenderer<ColdChicken, ColdChickenModel<ColdChicken>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"backported_animal_variants", (String)"textures/entity/cold_chicken.png");

    public ColdChickenRenderer(EntityRendererProvider.Context context) {
        super(context, new ColdChickenModel(context.bakeLayer(ModModelLayers.COLD_CHICKEN_LAYER)), 0.3f);
    }

    public ResourceLocation getTextureLocation(ColdChicken entity) {
        return TEXTURE;
    }

    protected float getBob(ColdChicken livingBase, float partialTicks) {
        float f = Mth.lerp((float)partialTicks, (float)livingBase.oFlap, (float)livingBase.flap);
        float g = Mth.lerp((float)partialTicks, (float)livingBase.oFlapSpeed, (float)livingBase.flapSpeed);
        return (Mth.sin((float)f) + 1.0f) * g;
    }
}

