/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.api.event.RollEvents;
import nl.enjarai.doabarrelroll.api.event.StarFox64Events;
import nl.enjarai.doabarrelroll.api.rotation.RotationInstant;
import nl.enjarai.doabarrelroll.config.ModConfig;

public class StarFoxUtil {
    private static final RandomSource random = RandomSource.create();
    private static final ResourceLocation barrelRollSoundId = DoABarrelRoll.id("do_a_barrel_roll");
    private static final SoundEvent barrelRollSound = SoundEvent.createVariableRangeEvent((ResourceLocation)barrelRollSoundId);
    private static final ResourceLocation barrelRollTexture1 = DoABarrelRoll.id("textures/gui/barrel_roll_1.png");
    private static final ResourceLocation barrelRollTexture2 = DoABarrelRoll.id("textures/gui/barrel_roll_2.png");
    private static final double rollTol = 90.0;
    private static double rollTracker = 0.0;
    private static int barrelRollTimer = 0;

    public static void register() {
        StarFox64Events.DOES_A_BARREL_ROLL.register(StarFoxUtil::playBarrelRollSound);
        StarFox64Events.DOES_A_BARREL_ROLL.register(player -> {
            barrelRollTimer = 30;
        });
        RollEvents.LATE_CAMERA_MODIFIERS.register(context -> StarFoxUtil.trackRoll(context.getRotationDelta(), context.getCurrentRotation()), 999999);
    }

    public static void clientTick(Minecraft client) {
        if (barrelRollTimer > 0) {
            --barrelRollTimer;
        }
    }

    public static void renderPeppy(GuiGraphics context, float tickDelta, int scaledWidth, int scaledHeight) {
        if (barrelRollTimer > 0) {
            int x = scaledWidth / 2 - 75;
            int y = scaledHeight - 90;
            int texture = barrelRollTimer % 2 == 0 ? 1 : 2;
            context.blit(texture == 1 ? barrelRollTexture1 : barrelRollTexture2, x, y, 0.0f, 0.0f, 160, 160, 160, 160);
        }
    }

    private static void trackRoll(RotationInstant rotationDelta, RotationInstant currentRotation) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && StarFoxUtil.isFoxMcCloud((Player)player)) {
            double cRoll = currentRotation.roll();
            double dRoll = rotationDelta.roll();
            if (cRoll < 90.0 && cRoll + dRoll >= 90.0) {
                rollTracker = 1.0;
            } else if (cRoll > -90.0 && cRoll + dRoll <= -90.0) {
                rollTracker = -1.0;
            } else if (rollTracker != 0.0) {
                if (rollTracker * dRoll < 0.0) {
                    rollTracker = 0.0;
                }
                if (rollTracker > 0.0 && cRoll <= -90.0 || rollTracker < 0.0 && cRoll >= 90.0) {
                    StarFox64Events.doesABarrelRoll(player);
                    rollTracker = 0.0;
                }
            }
        } else {
            rollTracker = 0.0;
        }
    }

    public static boolean isFoxMcCloud(Player player) {
        if (!ModConfig.INSTANCE.getEnableEasterEggs()) {
            return false;
        }
        ItemStack chestStack = player.getItemBySlot(EquipmentSlot.CHEST);
        String name = chestStack.getHoverName().getString();
        return chestStack.is(Items.ELYTRA) && (name.equals("Arwing") || name.equals("Star Fox 64") || name.contains("Do a Barrel Roll"));
    }

    public static void playBarrelRollSound(Player player) {
        player.level().playSound(player, (Entity)player, barrelRollSound, SoundSource.PLAYERS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.2f + 1.0f);
    }
}

