/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.util;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.Nullable;

public class ModPermissions {
    public static final PermissionDynamicContextKey<Integer> DEFAULT_PERMISSION_LEVEL_CONTEXT = new PermissionDynamicContextKey(Integer.class, "default_permission_level", Objects::toString);
    public static final PermissionNode<Boolean> IGNORE_CONFIG_NODE = new PermissionNode("do_a_barrel_roll", "ignore_config", PermissionTypes.BOOLEAN, ModPermissions::defaultResolve, new PermissionDynamicContextKey[]{DEFAULT_PERMISSION_LEVEL_CONTEXT});
    public static final PermissionNode<Boolean> CONFIGURE_NODE = new PermissionNode("do_a_barrel_roll", "configure", PermissionTypes.BOOLEAN, ModPermissions::defaultResolve, new PermissionDynamicContextKey[]{DEFAULT_PERMISSION_LEVEL_CONTEXT});
    public static final List<PermissionNode<Boolean>> NODES = List.of(IGNORE_CONFIG_NODE, CONFIGURE_NODE);

    public static boolean resolve(ServerPlayer player, String permission, int defaultPermissionLevel) {
        for (PermissionNode<Boolean> node : NODES) {
            if (!node.getNodeName().equals(permission)) continue;
            PermissionAPI.getPermission((ServerPlayer)player, node, (PermissionDynamicContext[])new PermissionDynamicContext[]{DEFAULT_PERMISSION_LEVEL_CONTEXT.createContext((Object)defaultPermissionLevel)});
        }
        return player.hasPermissions(defaultPermissionLevel);
    }

    private static boolean defaultResolve(@Nullable ServerPlayer player, UUID playerUUID, PermissionDynamicContext<?> ... context) {
        if (player != null) {
            for (PermissionDynamicContext<?> key : context) {
                if (key.getDynamic() != DEFAULT_PERMISSION_LEVEL_CONTEXT) continue;
                return player.hasPermissions(((Integer)key.getValue()).intValue());
            }
        }
        return false;
    }
}

