/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.config.ModConfigServer;
import nl.enjarai.doabarrelroll.net.HandshakeServer;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateAckS2CPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateC2SPacket;

public class ServerConfigHolder<P extends ConfigUpdateAckS2CPacket> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Path configFile;
    public final Codec<ModConfigServer> codec;
    private final PacketConstructor<P> packetConstructor;
    private final BiConsumer<MinecraftServer, ModConfigServer> updateCallback;
    private HandshakeServer<?> handshakeServer;
    public ModConfigServer instance;

    public ServerConfigHolder(Path configFile, Codec<ModConfigServer> codec, PacketConstructor<P> packetConstructor, BiConsumer<MinecraftServer, ModConfigServer> updateCallback) {
        this.configFile = configFile;
        this.codec = codec;
        this.packetConstructor = packetConstructor;
        this.updateCallback = updateCallback;
        this.load();
    }

    public void load() {
        ModConfigServer config = null;
        if (Files.exists(this.configFile, new LinkOption[0])) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader(Files.newInputStream(this.configFile, new OpenOption[0]), StandardCharsets.UTF_8));){
                config = (ModConfigServer)((Pair)this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)fileReader)).getOrThrow(e -> {
                    throw new RuntimeException((String)e);
                })).getFirst();
            }
            catch (IOException | RuntimeException e2) {
                DoABarrelRoll.LOGGER.error("Failed to parse server config file, regenerating: ", (Throwable)e2);
            }
        }
        if (config == null || !config.isValid()) {
            config = ModConfigServer.DEFAULT;
        }
        this.instance = config;
        this.save();
    }

    public void save() {
        try {
            Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
            Files.writeString(this.configFile, (CharSequence)GSON.toJson((JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.instance).getOrThrow(e -> {
                throw new RuntimeException((String)e);
            })), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException | RuntimeException e2) {
            DoABarrelRoll.LOGGER.error("Failed to save server config file: ", (Throwable)e2);
        }
    }

    public P clientSendsUpdate(ServerPlayer player, ConfigUpdateC2SPacket packet) {
        HandshakeServer.ClientInfo info = this.handshakeServer.getHandshakeState(player);
        boolean accepted = info.state == HandshakeServer.HandshakeState.ACCEPTED;
        boolean hasPermission = ModConfigServer.canModify(player.connection);
        if (!accepted || !hasPermission) {
            DoABarrelRoll.LOGGER.warn("Client of {} tried to update the server config, but is not allowed to. Rejecting.", (Object)player.getName().getString());
            return this.packetConstructor.construct(4, false);
        }
        try {
            ModConfigServer newConfig;
            int protocolVersion = packet.protocolVersion();
            if (protocolVersion != 4) {
                DoABarrelRoll.LOGGER.warn("Client of {} sent unknown protocol version for server config update, expected {}, got {}. Will attempt to proceed anyway.", new Object[]{player.getName().getString(), 4, protocolVersion});
            }
            if (!(newConfig = packet.config()).isValid()) {
                throw new RuntimeException("Config arrived, but contains invalid values");
            }
            DoABarrelRoll.LOGGER.info("{} updated the server config.", (Object)player.getName().getString());
            this.instance = newConfig;
            this.updateCallback.accept(player.getServer(), this.instance);
            this.save();
            return this.packetConstructor.construct(4, true);
        }
        catch (RuntimeException e) {
            DoABarrelRoll.LOGGER.warn("Client of {} sent invalid server config update, rejecting.", (Object)player.getName().getString(), (Object)e);
            return this.packetConstructor.construct(4, false);
        }
    }

    public void setHandshakeServer(HandshakeServer<?> handshakeServer) {
        this.handshakeServer = handshakeServer;
    }

    public static interface PacketConstructor<P extends ConfigUpdateAckS2CPacket> {
        public P construct(int var1, boolean var2);
    }
}

