/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import nl.enjarai.doabarrelroll.api.RollEntity;
import nl.enjarai.doabarrelroll.api.event.ClientEvents;
import nl.enjarai.doabarrelroll.config.ModConfigServer;
import nl.enjarai.doabarrelroll.net.HandshakeClient;
import nl.enjarai.doabarrelroll.net.ServerConfigUpdateClient;
import nl.enjarai.doabarrelroll.net.packet.ConfigResponseC2SPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigSyncS2CPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateAckS2CPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateC2SPacket;
import nl.enjarai.doabarrelroll.net.packet.RollSyncC2SPacket;
import nl.enjarai.doabarrelroll.net.packet.RollSyncS2CPacket;

public class ClientNetworking {
    public static final HandshakeClient<ConfigResponseC2SPacket> HANDSHAKE_CLIENT = new HandshakeClient<ConfigResponseC2SPacket>(ConfigResponseC2SPacket::new, ClientEvents::updateServerConfig);
    public static final ServerConfigUpdateClient<ConfigUpdateC2SPacket> CONFIG_UPDATE_CLIENT = new ServerConfigUpdateClient<ConfigUpdateC2SPacket>(ConfigUpdateC2SPacket::new);

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(ConfigSyncS2CPacket.PACKET_ID, (payload, context) -> {
            ConfigResponseC2SPacket response = HANDSHAKE_CLIENT.handleConfigSync((ConfigSyncS2CPacket)payload);
            context.responseSender().sendPacket((CustomPacketPayload)response);
            if (HANDSHAKE_CLIENT.hasConnected()) {
                ClientPlayNetworking.registerReceiver(RollSyncS2CPacket.PACKET_ID, (payload1, context1) -> {
                    Minecraft client = Minecraft.getInstance();
                    if (client.level == null) {
                        return;
                    }
                    Entity entity = client.level.getEntity(payload1.entityId());
                    if (entity == null) {
                        return;
                    }
                    RollEntity rollEntity = (RollEntity)entity;
                    rollEntity.doABarrelRoll$setRolling(payload1.rolling());
                    rollEntity.doABarrelRoll$setRoll(Mth.wrapDegrees((float)payload1.roll()));
                });
                ClientPlayNetworking.registerReceiver(ConfigUpdateAckS2CPacket.PACKET_ID, (payload1, context1) -> CONFIG_UPDATE_CLIENT.updateAcknowledged((ConfigUpdateAckS2CPacket)payload1));
            }
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> HANDSHAKE_CLIENT.reset());
    }

    public static void sendRollUpdate(RollEntity entity) {
        if (HANDSHAKE_CLIENT.hasConnected()) {
            boolean rolling = entity.doABarrelRoll$isRolling();
            float roll = entity.doABarrelRoll$getRoll();
            ClientPlayNetworking.send((CustomPacketPayload)new RollSyncC2SPacket(rolling, roll));
        }
    }

    public static void sendConfigUpdatePacket(ModConfigServer config) {
        ClientPlayNetworking.send((CustomPacketPayload)CONFIG_UPDATE_CLIENT.prepUpdatePacket(config));
    }
}

