/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.flight;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.SmoothDouble;
import net.minecraft.world.phys.Vec3;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.ModKeybindings;
import nl.enjarai.doabarrelroll.api.event.RollContext;
import nl.enjarai.doabarrelroll.api.rotation.RotationInstant;
import nl.enjarai.doabarrelroll.config.ModConfig;
import nl.enjarai.doabarrelroll.config.Sensitivity;
import nl.enjarai.doabarrelroll.math.Expression;

public class RotationModifiers {
    public static final double ROLL_REORIENT_CUTOFF = Math.sqrt(3.3333333333333335);

    public static RollContext.ConfiguresRotation buttonControls(double power) {
        return (rotationInstant, context) -> {
            double delta = power * context.getRenderDelta();
            double pitch = 0.0;
            double yaw = 0.0;
            double roll = 0.0;
            if (ModKeybindings.PITCH_UP.isDown()) {
                pitch -= delta;
            }
            if (ModKeybindings.PITCH_DOWN.isDown()) {
                pitch += delta;
            }
            if (ModKeybindings.YAW_LEFT.isDown()) {
                yaw -= delta;
            }
            if (ModKeybindings.YAW_RIGHT.isDown()) {
                yaw += delta;
            }
            if (ModKeybindings.ROLL_LEFT.isDown()) {
                roll -= delta;
            }
            if (ModKeybindings.ROLL_RIGHT.isDown()) {
                roll += delta;
            }
            return rotationInstant.add(pitch, yaw, roll);
        };
    }

    public static RollContext.ConfiguresRotation smoothing(SmoothDouble pitchSmoother, SmoothDouble yawSmoother, SmoothDouble rollSmoother, Sensitivity smoothness) {
        return (rotationInstant, context) -> RotationInstant.of(smoothness.pitch == 0.0 ? rotationInstant.pitch() : pitchSmoother.getNewDeltaValue(rotationInstant.pitch(), 1.0 / smoothness.pitch * context.getRenderDelta()), smoothness.yaw == 0.0 ? rotationInstant.yaw() : yawSmoother.getNewDeltaValue(rotationInstant.yaw(), 1.0 / smoothness.yaw * context.getRenderDelta()), smoothness.roll == 0.0 ? rotationInstant.roll() : rollSmoother.getNewDeltaValue(rotationInstant.roll(), 1.0 / smoothness.roll * context.getRenderDelta()));
    }

    public static RotationInstant banking(RotationInstant rotationInstant, RollContext context) {
        double delta = context.getRenderDelta();
        RotationInstant currentRotation = context.getCurrentRotation();
        double currentRoll = currentRotation.roll() * (Math.PI / 180);
        Expression xExpression = ModConfig.INSTANCE.getBankingXFormula().getCompiledOrDefaulting(0.0);
        Expression yExpression = ModConfig.INSTANCE.getBankingYFormula().getCompiledOrDefaulting(0.0);
        Map<String, Double> vars = RotationModifiers.getVars(context);
        vars.put("banking_strength", ModConfig.INSTANCE.getBankingStrength());
        double dX = xExpression.eval(vars);
        double dY = yExpression.eval(vars);
        if (Double.isNaN(dX)) {
            dX = 0.0;
        }
        if (Double.isNaN(dY)) {
            dY = 0.0;
        }
        return rotationInstant.addAbsolute(dX * delta, dY * delta, currentRoll);
    }

    public static RotationInstant reorient(RotationInstant rotationInstant, RollContext context) {
        double delta = context.getRenderDelta();
        double currentRoll = context.getCurrentRotation().roll() * (Math.PI / 180);
        double strength = 10.0 * ModConfig.INSTANCE.getRightingStrength();
        double cutoff = ROLL_REORIENT_CUTOFF;
        double rollDelta = 0.0;
        if (-cutoff < currentRoll && currentRoll < cutoff) {
            rollDelta = -Math.pow(currentRoll, 3.0) / 3.0 + currentRoll;
        }
        return rotationInstant.add(0.0, 0.0, -rollDelta * strength * delta);
    }

    public static RollContext.ConfiguresRotation fixNaN(String name) {
        return (rotationInstant, context) -> {
            if (Double.isNaN(rotationInstant.pitch())) {
                rotationInstant = RotationInstant.of(0.0, rotationInstant.yaw(), rotationInstant.roll());
                DoABarrelRoll.LOGGER.warn("NaN found in pitch for {}, setting to 0 as fallback", (Object)name);
            }
            if (Double.isNaN(rotationInstant.yaw())) {
                rotationInstant = RotationInstant.of(rotationInstant.pitch(), 0.0, rotationInstant.roll());
                DoABarrelRoll.LOGGER.warn("NaN found in yaw for {}, setting to 0 as fallback", (Object)name);
            }
            if (Double.isNaN(rotationInstant.roll())) {
                rotationInstant = RotationInstant.of(rotationInstant.pitch(), rotationInstant.yaw(), 0.0);
                DoABarrelRoll.LOGGER.warn("NaN found in roll for {}, setting to 0 as fallback", (Object)name);
            }
            return rotationInstant;
        };
    }

    public static RotationInstant applyControlSurfaceEfficacy(RotationInstant rotationInstant, RollContext context) {
        Expression elevatorExpression = ModConfig.INSTANCE.getElevatorEfficacyFormula().getCompiledOrDefaulting(1.0);
        Expression aileronExpression = ModConfig.INSTANCE.getAileronEfficacyFormula().getCompiledOrDefaulting(1.0);
        Expression rudderExpression = ModConfig.INSTANCE.getRudderEfficacyFormula().getCompiledOrDefaulting(1.0);
        Map<String, Double> vars = RotationModifiers.getVars(context);
        return rotationInstant.multiply(elevatorExpression.eval(vars), rudderExpression.eval(vars), aileronExpression.eval(vars));
    }

    private static Map<String, Double> getVars(RollContext context) {
        final LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        final RotationInstant currentRotation = context.getCurrentRotation();
        final Vec3 rotationVector = player.getLookAngle();
        return new HashMap<String, Double>(){
            {
                this.put("pitch", currentRotation.pitch());
                this.put("yaw", currentRotation.yaw());
                this.put("roll", currentRotation.roll());
                this.put("velocity_length", player.getDeltaMovement().length());
                this.put("velocity_x", player.getDeltaMovement().x());
                this.put("velocity_y", player.getDeltaMovement().y());
                this.put("velocity_z", player.getDeltaMovement().z());
                this.put("look_x", rotationVector.x());
                this.put("look_y", rotationVector.y());
                this.put("look_z", rotationVector.z());
            }
        };
    }
}

