/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import nl.enjarai.doabarrelroll.DoABarrelRollClient;
import nl.enjarai.doabarrelroll.ModKeybindings;
import nl.enjarai.doabarrelroll.api.RollEntity;
import nl.enjarai.doabarrelroll.api.RollMouse;
import nl.enjarai.doabarrelroll.config.ModConfig;
import nl.enjarai.doabarrelroll.impl.key.InputContextImpl;
import nl.enjarai.doabarrelroll.render.HorizonLineWidget;
import nl.enjarai.doabarrelroll.render.MomentumCrosshairWidget;
import nl.enjarai.doabarrelroll.util.StarFoxUtil;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class EventCallbacksClient {
    public static void clientTick(Minecraft client) {
        InputContextImpl.getContexts().forEach(InputContextImpl::tick);
        if (!DoABarrelRollClient.isFallFlying()) {
            DoABarrelRollClient.clearValues();
        }
        ModKeybindings.clientTick(client);
        StarFoxUtil.clientTick(client);
    }

    public static void onRenderCrosshair(GuiGraphics context, DeltaTracker tickCounter, int scaledWidth, int scaledHeight) {
        if (!DoABarrelRollClient.isFallFlying()) {
            return;
        }
        float tickDelta = tickCounter.getGameTimeDeltaPartialTick(true);
        PoseStack matrices = context.pose();
        Entity entity = Minecraft.getInstance().getCameraEntity();
        RollEntity rollEntity = (RollEntity)entity;
        if (entity != null) {
            if (ModConfig.INSTANCE.getShowHorizon()) {
                HorizonLineWidget.render(matrices, scaledWidth, scaledHeight, rollEntity.doABarrelRoll$getRoll(tickDelta), entity.getViewXRot(tickDelta));
            }
            if (ModConfig.INSTANCE.getMomentumBasedMouse() && ModConfig.INSTANCE.getShowMomentumWidget()) {
                RollMouse rollMouse = (RollMouse)Minecraft.getInstance().mouseHandler;
                MomentumCrosshairWidget.render(matrices, scaledWidth, scaledHeight, new Vector2d((Vector2dc)rollMouse.doABarrelRoll$getMouseTurnVec()));
            }
        }
    }
}

