/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.mixin.client;

import com.blackgear.vanillabackport.common.api.bundle.BundleFeatures;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModItemTags;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractContainerScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements MenuAccess<T> {
    @Shadow
    protected int imageWidth;
    @Unique
    private static final ResourceLocation BUNDLE_OPEN_BACK = VanillaBackport.vanilla("textures/item/bundle_open_back.png");
    @Unique
    private static final ResourceLocation BUNDLE_OPEN_FRONT = VanillaBackport.vanilla("textures/item/bundle_open_front.png");

    protected AbstractContainerScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void vb$renderBundleContents(GuiGraphics graphics, Slot slot, CallbackInfo ci) {
        ItemStack selectedItem;
        ItemStack stack = slot.getItem();
        if (stack.is(ModItemTags.BUNDLES) && !(selectedItem = BundleFeatures.getSelectedItemStack(stack)).isEmpty()) {
            ResourceLocation backTexture = BUNDLE_OPEN_BACK;
            ResourceLocation frontTexture = BUNDLE_OPEN_FRONT;
            for (DyeColor color : DyeColor.values()) {
                if (!stack.is(BundleFeatures.getByColor(color)) || stack.is(Items.BUNDLE)) continue;
                backTexture = VanillaBackport.vanilla("textures/item/" + color.getName() + "_bundle_open_back.png");
                frontTexture = VanillaBackport.vanilla("textures/item/" + color.getName() + "_bundle_open_front.png");
                break;
            }
            PoseStack pose = graphics.pose();
            int slotX = slot.x;
            int slotY = slot.y;
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 100.0f);
            graphics.blit(backTexture, slotX, slotY, 0.0f, 0.0f, 16, 16, 16, 16);
            graphics.renderItem(selectedItem, slotX, slotY, slot.x + slot.y * this.imageWidth);
            pose.pushPose();
            pose.translate(0.0f, 0.0f, 200.0f);
            graphics.blit(frontTexture, slotX, slotY, 0.0f, 0.0f, 16, 16, 16, 16);
            graphics.renderItemDecorations(this.font, stack, slotX, slotY);
            pose.popPose();
            pose.popPose();
            ci.cancel();
        }
    }
}

