/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.worldgen.treedecorators;

import com.blackgear.vanillabackport.common.level.blocks.HangingMossBlock;
import com.blackgear.vanillabackport.common.registries.ModBlocks;
import com.blackgear.vanillabackport.common.registries.ModTreeDecorators;
import com.blackgear.vanillabackport.common.worldgen.features.TheGardenAwakensFeatures;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class PaleMossDecorator
extends TreeDecorator {
    public static final MapCodec<PaleMossDecorator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("leaves_probability").forGetter(decorator -> Float.valueOf(decorator.leavesProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("trunk_probability").forGetter(decorator -> Float.valueOf(decorator.trunkProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("ground_probability").forGetter(decorator -> Float.valueOf(decorator.groundProbability))).apply((Applicative)instance, PaleMossDecorator::new));
    private final float leavesProbability;
    private final float trunkProbability;
    private final float groundProbability;

    public PaleMossDecorator(float leavesProbability, float trunkProbability, float groundProbability) {
        this.leavesProbability = leavesProbability;
        this.trunkProbability = trunkProbability;
        this.groundProbability = groundProbability;
    }

    protected TreeDecoratorType<?> type() {
        return ModTreeDecorators.PALE_MOSS.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        WorldGenLevel level = (WorldGenLevel)context.level();
        List positions = Util.shuffledCopy((ObjectArrayList)context.logs(), (RandomSource)random);
        if (!positions.isEmpty()) {
            MutableObject mutable = new MutableObject((Object)((BlockPos)positions.getFirst()));
            positions.forEach(arg_0 -> PaleMossDecorator.lambda$place$4((Mutable)mutable, arg_0));
            BlockPos position = (BlockPos)mutable.getValue();
            if (random.nextFloat() < this.groundProbability) {
                level.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(registry -> registry.get(TheGardenAwakensFeatures.PALE_MOSS_PATCH)).ifPresent(reference -> ((ConfiguredFeature)reference.value()).place(level, level.getLevel().getChunkSource().getGenerator(), random, position.above()));
            }
            context.logs().forEach(pos -> {
                BlockPos below;
                if (random.nextFloat() < this.trunkProbability && context.isAir(below = pos.below())) {
                    PaleMossDecorator.addMossHanger(below, context);
                }
            });
            context.leaves().forEach(pos -> {
                BlockPos below;
                if (random.nextFloat() < this.leavesProbability && context.isAir(below = pos.below())) {
                    PaleMossDecorator.addMossHanger(below, context);
                }
            });
        }
    }

    private static void addMossHanger(BlockPos pos, TreeDecorator.Context context) {
        while (context.isAir(pos.below()) && context.random().nextFloat() >= 0.5f) {
            context.setBlock(pos, (BlockState)ModBlocks.PALE_HANGING_MOSS.get().defaultBlockState().setValue((Property)HangingMossBlock.TIP, (Comparable)Boolean.valueOf(false)));
            pos = pos.below();
        }
        context.setBlock(pos, (BlockState)ModBlocks.PALE_HANGING_MOSS.get().defaultBlockState().setValue((Property)HangingMossBlock.TIP, (Comparable)Boolean.valueOf(true)));
    }

    private static /* synthetic */ void lambda$place$4(Mutable mutable, BlockPos pos) {
        if (pos.getY() < ((BlockPos)mutable.getValue()).getY()) {
            mutable.setValue((Object)pos);
        }
    }
}

