/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FireflyParticle
extends TextureSheetParticle {
    private static final float PARTICLE_FADE_OUT_LIGHT_TIME = 0.3f;
    private static final float PARTICLE_FADE_IN_LIGHT_TIME = 0.1f;
    private static final float PARTICLE_FADE_OUT_ALPHA_TIME = 0.5f;
    private static final float PARTICLE_FADE_IN_ALPHA_TIME = 0.3f;
    private static final int PARTICLE_MIN_LIFETIME = 200;
    private static final int PARTICLE_MAX_LIFETIME = 300;

    protected FireflyParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.speedUpWhenYMotionIsBlocked = true;
        this.friction = 0.96f;
        this.quadSize *= 0.75f;
        this.yd *= (double)0.8f;
        this.xd *= (double)0.8f;
        this.zd *= (double)0.8f;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected int getLightColor(float partialTick) {
        return (int)(255.0f * this.getFadeAmount(this.getLifetimeProgress((float)this.age + partialTick), 0.1f, 0.3f));
    }

    public void tick() {
        super.tick();
        if (!this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z)).isAir()) {
            this.remove();
        } else {
            this.setAlpha(this.getFadeAmount(this.getLifetimeProgress(this.age), 0.3f, 0.5f));
            if (Math.random() > 0.95 || this.age == 1) {
                this.setParticleSpeed(-0.05 + (double)0.1f * Math.random(), -0.05 + (double)0.1f * Math.random(), -0.05 + (double)0.1f * Math.random());
            }
        }
    }

    private float getLifetimeProgress(float age) {
        return Mth.clamp((float)(age / (float)this.lifetime), (float)0.0f, (float)1.0f);
    }

    private float getFadeAmount(float lifetime, float fadeIn, float fadeOut) {
        if (lifetime >= 1.0f - fadeIn) {
            return (1.0f - lifetime) / fadeIn;
        }
        return lifetime <= fadeOut ? lifetime / fadeOut : 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Provider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FireflyParticle particle = new FireflyParticle(level, x, y, z, 0.5 - level.random.nextDouble(), level.random.nextBoolean() ? ySpeed : -ySpeed, 0.5 - level.random.nextDouble());
            particle.setLifetime(level.random.nextIntBetweenInclusive(200, 300));
            particle.scale(1.5f);
            particle.pickSprite(this.sprite);
            particle.setAlpha(0.0f);
            return particle;
        }
    }
}

