/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.renderer;

import com.blackgear.vanillabackport.client.registries.ModModelLayers;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class PaleOakBoatRenderer
extends BoatRenderer {
    private static final ResourceLocation PALE_OAK_BOAT = VanillaBackport.vanilla("textures/entity/boat/pale_oak.png");
    private static final ResourceLocation PALE_OAK_CHEST_BOAT = VanillaBackport.vanilla("textures/entity/chest_boat/pale_oak.png");
    private final Pair<ResourceLocation, ListModel<Boat>> boatResource;

    public PaleOakBoatRenderer(EntityRendererProvider.Context context, boolean chestBoat) {
        super(context, chestBoat);
        this.boatResource = Pair.of((Object)(chestBoat ? PALE_OAK_CHEST_BOAT : PALE_OAK_BOAT), (Object)(chestBoat ? new ChestBoatModel(context.bakeLayer(ModModelLayers.PALE_OAK_CHEST_BOAT)) : new BoatModel(context.bakeLayer(ModModelLayers.PALE_OAK_BOAT))));
    }

    public void render(Boat entity, float entityYaw, float partialTick, PoseStack matrices, MultiBufferSource buffer, int packedLight) {
        float bubbleAngle;
        matrices.pushPose();
        matrices.translate(0.0f, 0.375f, 0.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f - entityYaw));
        float hurtTime = (float)entity.getHurtTime() - partialTick;
        float tilt = entity.getDamage() - partialTick;
        if (tilt < 0.0f) {
            tilt = 0.0f;
        }
        if (hurtTime > 0.0f) {
            matrices.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)hurtTime) * hurtTime * tilt / 10.0f * (float)entity.getHurtDir()));
        }
        if (!Mth.equal((float)(bubbleAngle = entity.getBubbleAngle(partialTick)), (float)0.0f)) {
            matrices.mulPose(new Quaternionf().setAngleAxis(entity.getBubbleAngle(partialTick) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, ListModel<Boat>> pair = this.getModelWithLocation(entity);
        ResourceLocation texture = (ResourceLocation)pair.getFirst();
        ListModel model = (ListModel)pair.getSecond();
        matrices.scale(-1.0f, -1.0f, 1.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
        model.setupAnim((Entity)entity, partialTick, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertices = buffer.getBuffer(model.renderType(texture));
        model.renderToBuffer(matrices, vertices, packedLight, OverlayTexture.NO_OVERLAY);
        if (!entity.isUnderWater()) {
            VertexConsumer patch = buffer.getBuffer(RenderType.waterMask());
            if (model instanceof WaterPatchModel) {
                WaterPatchModel waterpatchmodel = (WaterPatchModel)model;
                waterpatchmodel.waterPatch().render(matrices, patch, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
        matrices.popPose();
        Entity leashHolder = entity.getLeashHolder();
        if (leashHolder != null) {
            this.renderLeash((Entity)entity, partialTick, matrices, buffer, leashHolder);
        }
        if (this.shouldShowName((Entity)entity)) {
            this.renderNameTag((Entity)entity, entity.getDisplayName(), matrices, buffer, packedLight, partialTick);
        }
    }

    public ResourceLocation getTextureLocation(Boat entity) {
        return (ResourceLocation)this.getModelWithLocation(entity).getFirst();
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        return this.boatResource;
    }
}

