/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.init;

import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.common.entity.HatDisplay;
import fonnymunkey.simplehats.common.init.IModRegistry;
import fonnymunkey.simplehats.common.item.BagItem;
import fonnymunkey.simplehats.common.item.HatDisplayItem;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.common.recipe.HatScrapRecipe;
import fonnymunkey.simplehats.common.recipe.HatVariantRecipe;
import fonnymunkey.simplehats.util.HatEntry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModRegistry
implements IModRegistry {
    private static final List<HatItem> HAT_LIST = new ArrayList<HatItem>();
    private static final DeferredRegister<CreativeModeTab> TAB_REG = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"simplehats");
    private static final DeferredHolder<CreativeModeTab, CreativeModeTab> HAT_TAB = TAB_REG.register("simplehats", () -> CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatIcon())).title((Component)Component.translatable((String)"itemGroup.simplehats.hat_group")).displayItems((context, entries) -> {
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagCommon());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagUncommon());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagRare());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagEpic());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagEaster());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagSummer());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagHalloween());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatBagFestive());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsCommon());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsUncommon());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsRare());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsEaster());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsSummer());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsHalloween());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatScrapsFestive());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatIcon());
        entries.accept((ItemLike)SimpleHatsCommon.MOD_REGISTRY.getHatDisplayItem());
        for (HatItem hat : SimpleHatsCommon.MOD_REGISTRY.getHatList()) {
            entries.accept((ItemLike)hat);
        }
    }).build());
    private static final DeferredRegister<Item> ITEM_REG = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"simplehats");
    private static final DeferredHolder<Item, BagItem> HATBAG_COMMON = ITEM_REG.register("hatbag_common", () -> new BagItem(Rarity.COMMON));
    private static final DeferredHolder<Item, BagItem> HATBAG_UNCOMMON = ITEM_REG.register("hatbag_uncommon", () -> new BagItem(Rarity.UNCOMMON));
    private static final DeferredHolder<Item, BagItem> HATBAG_RARE = ITEM_REG.register("hatbag_rare", () -> new BagItem(Rarity.RARE));
    private static final DeferredHolder<Item, BagItem> HATBAG_EPIC = ITEM_REG.register("hatbag_epic", () -> new BagItem(Rarity.EPIC));
    private static final DeferredHolder<Item, BagItem> HATBAG_EASTER = ITEM_REG.register("hatbag_easter", () -> new BagItem(HatEntry.HatSeason.EASTER));
    private static final DeferredHolder<Item, BagItem> HATBAG_SUMMER = ITEM_REG.register("hatbag_summer", () -> new BagItem(HatEntry.HatSeason.SUMMER));
    private static final DeferredHolder<Item, BagItem> HATBAG_HALLOWEEN = ITEM_REG.register("hatbag_halloween", () -> new BagItem(HatEntry.HatSeason.HALLOWEEN));
    private static final DeferredHolder<Item, BagItem> HATBAG_FESTIVE = ITEM_REG.register("hatbag_festive", () -> new BagItem(HatEntry.HatSeason.FESTIVE));
    private static final DeferredHolder<Item, Item> HATSCRAPS_COMMON = ITEM_REG.register("hatscraps_common", () -> new Item(new Item.Properties().rarity(Rarity.COMMON)));
    private static final DeferredHolder<Item, Item> HATSCRAPS_UNCOMMON = ITEM_REG.register("hatscraps_uncommon", () -> new Item(new Item.Properties().rarity(Rarity.UNCOMMON)));
    private static final DeferredHolder<Item, Item> HATSCRAPS_RARE = ITEM_REG.register("hatscraps_rare", () -> new Item(new Item.Properties().rarity(Rarity.RARE)));
    private static final DeferredHolder<Item, Item> HATSCRAPS_EASTER = ITEM_REG.register("hatscraps_easter", () -> new Item(new Item.Properties().rarity(Rarity.EPIC)));
    private static final DeferredHolder<Item, Item> HATSCRAPS_SUMMER = ITEM_REG.register("hatscraps_summer", () -> new Item(new Item.Properties().rarity(Rarity.EPIC)));
    private static final DeferredHolder<Item, Item> HATSCRAPS_HALLOWEEN = ITEM_REG.register("hatscraps_halloween", () -> new Item(new Item.Properties().rarity(Rarity.EPIC)));
    private static final DeferredHolder<Item, Item> HATSCRAPS_FESTIVE = ITEM_REG.register("hatscraps_festive", () -> new Item(new Item.Properties().rarity(Rarity.EPIC)));
    private static final DeferredHolder<Item, Item> HATICON = ITEM_REG.register("haticon", () -> new Item(new Item.Properties()));
    private static final DeferredHolder<Item, HatDisplayItem> HATDISPLAYITEM = ITEM_REG.register("hatdisplay", () -> new HatDisplayItem(new Item.Properties()));
    private static final DeferredHolder<Item, HatItem> HATSPECIAL = ITEM_REG.register("special", () -> new HatItem(new HatEntry("special", Rarity.EPIC, 0)));
    private static final DeferredRegister<EntityType<?>> ENTITY_REG = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"simplehats");
    private static final DeferredHolder<EntityType<?>, EntityType<HatDisplay>> HATDISPLAYENTITY = ENTITY_REG.register("hatdisplay", () -> EntityType.Builder.of(HatDisplay::new, (MobCategory)MobCategory.MISC).sized(0.75f, 0.8125f).clientTrackingRange(10).build("hatdisplay"));
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_REG = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"simplehats");
    private static final DeferredHolder<RecipeSerializer<?>, SimpleCraftingRecipeSerializer<HatScrapRecipe>> HATSCRAP_SERIALIZER = RECIPE_REG.register("custom_hatscraps", () -> new SimpleCraftingRecipeSerializer(HatScrapRecipe::new));
    private static final DeferredHolder<RecipeSerializer<?>, SimpleCraftingRecipeSerializer<HatVariantRecipe>> HATVARIANTS_SERIALIZER = RECIPE_REG.register("custom_hatvariants", () -> new SimpleCraftingRecipeSerializer(HatVariantRecipe::new));

    public static void registerHats(IEventBus eventBus) {
        ITEM_REG.register(eventBus);
        TAB_REG.register(eventBus);
        ENTITY_REG.register(eventBus);
        RECIPE_REG.register(eventBus);
    }

    @Override
    public List<HatItem> getHatList() {
        return HAT_LIST;
    }

    @Override
    public BagItem getHatBagCommon() {
        return (BagItem)((Object)HATBAG_COMMON.get());
    }

    @Override
    public BagItem getHatBagUncommon() {
        return (BagItem)((Object)HATBAG_UNCOMMON.get());
    }

    @Override
    public BagItem getHatBagRare() {
        return (BagItem)((Object)HATBAG_RARE.get());
    }

    @Override
    public BagItem getHatBagEpic() {
        return (BagItem)((Object)HATBAG_EPIC.get());
    }

    @Override
    public BagItem getHatBagEaster() {
        return (BagItem)((Object)HATBAG_EASTER.get());
    }

    @Override
    public BagItem getHatBagSummer() {
        return (BagItem)((Object)HATBAG_SUMMER.get());
    }

    @Override
    public BagItem getHatBagHalloween() {
        return (BagItem)((Object)HATBAG_HALLOWEEN.get());
    }

    @Override
    public BagItem getHatBagFestive() {
        return (BagItem)((Object)HATBAG_FESTIVE.get());
    }

    @Override
    public Item getHatScrapsCommon() {
        return (Item)HATSCRAPS_COMMON.get();
    }

    @Override
    public Item getHatScrapsUncommon() {
        return (Item)HATSCRAPS_UNCOMMON.get();
    }

    @Override
    public Item getHatScrapsRare() {
        return (Item)HATSCRAPS_RARE.get();
    }

    @Override
    public Item getHatScrapsEaster() {
        return (Item)HATSCRAPS_EASTER.get();
    }

    @Override
    public Item getHatScrapsSummer() {
        return (Item)HATSCRAPS_SUMMER.get();
    }

    @Override
    public Item getHatScrapsHalloween() {
        return (Item)HATSCRAPS_HALLOWEEN.get();
    }

    @Override
    public Item getHatScrapsFestive() {
        return (Item)HATSCRAPS_FESTIVE.get();
    }

    @Override
    public Item getHatIcon() {
        return (Item)HATICON.get();
    }

    @Override
    public HatDisplayItem getHatDisplayItem() {
        return (HatDisplayItem)((Object)HATDISPLAYITEM.get());
    }

    @Override
    public HatItem getHatSpecial() {
        return (HatItem)((Object)HATSPECIAL.get());
    }

    @Override
    public EntityType<HatDisplay> getHatDisplayEntity() {
        return (EntityType)HATDISPLAYENTITY.get();
    }

    @Override
    public RecipeSerializer<?> getHatScrapSerializer() {
        return (RecipeSerializer)HATSCRAP_SERIALIZER.get();
    }

    @Override
    public RecipeSerializer<?> getHatVariantSerializer() {
        return (RecipeSerializer)HATVARIANTS_SERIALIZER.get();
    }
}

