/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.recipe;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import mod.chiselsandbits.forge.data.recipe.AbstractRecipeGenerator;
import mod.chiselsandbits.registrars.ModBlocks;
import mod.chiselsandbits.registrars.ModTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="chiselsandbits", bus=EventBusSubscriber.Bus.MOD)
public class MachineBlocksRecipeGenerator
extends AbstractRecipeGenerator {
    private final List<String> pattern;
    private final Map<Character, TagKey<Item>> tagMap;
    private final Map<Character, ItemLike> itemMap;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().addProvider(true, (DataProvider)new MachineBlocksRecipeGenerator(event.getGenerator().getPackOutput(), (ItemLike)ModBlocks.CHISELED_PRINTER.get(), " c ;l l;sss", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('c'), (Object)ModTags.Items.CHISEL, (Object)Character.valueOf('l'), (Object)ItemTags.LOGS), (Map<Character, ItemLike>)ImmutableMap.of((Object)Character.valueOf('s'), (Object)Blocks.SMOOTH_STONE_SLAB), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new MachineBlocksRecipeGenerator(event.getGenerator().getPackOutput(), (ItemLike)ModBlocks.MODIFICATION_TABLE.get(), "scs;nbn;ppp", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('s'), (Object)ItemTags.WOODEN_SLABS, (Object)Character.valueOf('n'), (Object)Tags.Items.NUGGETS_IRON, (Object)Character.valueOf('b'), (Object)ItemTags.LOGS, (Object)Character.valueOf('p'), (Object)ItemTags.PLANKS, (Object)Character.valueOf('c'), (Object)ModTags.Items.CHISEL), (Map<Character, ItemLike>)ImmutableMap.of(), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new MachineBlocksRecipeGenerator(event.getGenerator().getPackOutput(), (ItemLike)ModBlocks.BIT_STORAGE.get(), "igi;glg;ici", (Map<Character, TagKey<Item>>)ImmutableMap.of((Object)Character.valueOf('g'), (Object)Tags.Items.GLASS_BLOCKS, (Object)Character.valueOf('l'), (Object)ItemTags.LOGS, (Object)Character.valueOf('i'), (Object)Tags.Items.INGOTS_IRON, (Object)Character.valueOf('c'), (Object)ModTags.Items.CHISEL), (Map<Character, ItemLike>)ImmutableMap.of(), event.getLookupProvider()));
    }

    private MachineBlocksRecipeGenerator(PackOutput generator, ItemLike result, String pattern, Map<Character, TagKey<Item>> tagMap, Map<Character, ItemLike> itemMap, CompletableFuture<HolderLookup.Provider> registries) {
        super(generator, result, registries);
        this.pattern = Arrays.asList(pattern.split(";"));
        this.tagMap = tagMap;
        this.itemMap = itemMap;
    }

    protected void buildRecipes(@NotNull RecipeOutput writer) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)this.getItemProvider());
        this.pattern.forEach(arg_0 -> ((ShapedRecipeBuilder)builder).pattern(arg_0));
        this.tagMap.forEach((ingredientKey, tag) -> {
            builder.define(ingredientKey, tag);
            builder.unlockedBy("has_" + ingredientKey, MachineBlocksRecipeGenerator.has((TagKey)tag));
        });
        this.itemMap.forEach((ingredientKey, item) -> {
            builder.define(ingredientKey, item);
            builder.unlockedBy("has_" + ingredientKey, MachineBlocksRecipeGenerator.has((ItemLike)item));
        });
        builder.save(writer);
    }
}

