/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.item;

import java.util.List;
import java.util.function.Consumer;
import net.mcreator.createstuffadditions.network.CreateSaModVariables;
import net.mcreator.createstuffadditions.procedures.FlamethrowerItemInHandTickProcedure;
import net.mcreator.createstuffadditions.procedures.FlamethrowerRightclickedProcedure;
import net.mcreator.createstuffadditions.procedures.LocalizationHandlerProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class FlamethrowerItem
extends Item {
    public FlamethrowerItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.COMMON));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                if (!itemStack.isEmpty()) {
                    return HumanoidModel.ArmPose.BOW_AND_ARROW;
                }
                return HumanoidModel.ArmPose.ITEM;
            }
        });
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBarWidth(ItemStack stack) {
        LocalPlayer entity;
        LocalPlayer localPlayer = entity = Minecraft.getInstance().player != null ? Minecraft.getInstance().player : null;
        if (entity != null) {
            if (((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") > CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity) {
                return 13;
            }
            return (int)(((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") * (1.0 / CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity) * 13.0);
        }
        return (int)(((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") * 0.0 * 13.0);
    }

    public int getBarColor(ItemStack stack) {
        return 16099696;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        LocalPlayer entity = Minecraft.getInstance().player != null ? Minecraft.getInstance().player : null;
        int tagFuel = 0;
        tagFuel = (int)((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel");
        if (entity != null) {
            if (Screen.hasShiftDown()) {
                list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.holdshift").getString().replace("\u00a77", "\u00a7f")));
                list.add((Component)Component.literal((String)(Component.translatable((String)"item_desc.fuel").getString() + " \u00a78" + tagFuel + "/" + Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity))));
                list.add((Component)Component.literal((String)" "));
                list.addAll(LocalizationHandlerProcedure.execute(Component.translatable((String)"item_desc.flamethrower.desc").getString(), 0));
                list.add((Component)Component.literal((String)" "));
                list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.used").getString()));
                list.addAll(LocalizationHandlerProcedure.execute(Component.translatable((String)"item_desc.flamethrower.desc2").getString(), 1));
            } else {
                list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.holdshift").getString()));
                list.add((Component)Component.literal((String)(Component.translatable((String)"item_desc.fuel").getString() + " \u00a78" + tagFuel + "/" + Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity))));
            }
        }
        super.appendHoverText(itemstack, context, list, flag);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        FlamethrowerRightclickedProcedure.execute((Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    public boolean overrideOtherStackedOnMe(ItemStack localTool, ItemStack potentialFuel, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (localTool.getCount() > 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        if (potentialFuel.getBurnTime(null) > 0) {
            if (((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") >= CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity) {
                return false;
            }
            double fuelBonus = Math.round((double)potentialFuel.getBurnTime(null) * 0.005);
            if (Screen.hasControlDown()) {
                int insertedAmount = potentialFuel.getCount();
                double totalFuelBonus = fuelBonus * (double)potentialFuel.getCount();
                if (((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + fuelBonus > CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity) {
                    insertedAmount += (int)Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity - ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") / fuelBonus);
                }
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)localTool, tag -> tag.putDouble("tagFuel", ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + totalFuelBonus > CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity ? CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity : ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + totalFuelBonus));
                if (potentialFuel.getItem() == Items.LAVA_BUCKET) {
                    if (potentialFuel.getCount() == 1) {
                        access.set(new ItemStack((ItemLike)Items.BUCKET));
                    }
                    if (potentialFuel.getCount() > 1) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET));
                    }
                }
                potentialFuel.shrink(insertedAmount);
            } else {
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)localTool, tag -> tag.putDouble("tagFuel", ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + fuelBonus > CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity ? CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity : ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + fuelBonus));
                if (potentialFuel.getItem() == Items.LAVA_BUCKET) {
                    if (potentialFuel.getCount() == 1) {
                        access.set(new ItemStack((ItemLike)Items.BUCKET));
                    }
                    if (potentialFuel.getCount() > 1) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET));
                    }
                }
                potentialFuel.shrink(1);
            }
            this.playSound(player, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.fire.extinguish")));
            return true;
        }
        return false;
    }

    protected void playSound(Player player, SoundEvent soundEvent) {
        player.playSound(soundEvent, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.1f);
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            FlamethrowerItemInHandTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
        }
    }
}

