/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplateStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModBlockColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.init.ModItemColors;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackBlockEntityRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackDynamicModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackItemStackRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackLayerRenderer;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.ClientBackpackContentsTooltip;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.BlockPickPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.network.RequestPlayerSettingsPayload;

public class ClientEventHandler {
    private static final String BACKPACK_REG_NAME = "backpack";
    public static final ModelLayerLocation BACKPACK_LAYER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)"backpack"), "main");

    private ClientEventHandler() {
    }

    public static void registerHandlers(IEventBus modBus) {
        modBus.addListener(ClientEventHandler::onModelRegistry);
        modBus.addListener(ClientEventHandler::registerLayer);
        modBus.addListener(ClientEventHandler::registerEntityRenderers);
        modBus.addListener(ClientEventHandler::registerReloadListener);
        modBus.addListener(ModItemColors::registerItemColorHandlers);
        modBus.addListener(ModBlockColors::registerBlockColorHandlers);
        modBus.addListener(ClientEventHandler::registerBackpackClientExtension);
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(ClientBackpackContentsTooltip::onWorldLoad);
        eventBus.addListener(ClientEventHandler::handleBlockPick);
        eventBus.addListener(ClientEventHandler::onPlayerLoggingIn);
        eventBus.addListener(BackpackStorage::onClientWorldLoad);
        eventBus.addListener(BackpackTemplateStorage::onClientWorldLoad);
    }

    private static void onPlayerLoggingIn(ClientPlayerNetworkEvent.LoggingIn event) {
        PacketDistributor.sendToServer((CustomPacketPayload)new RequestPlayerSettingsPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void onModelRegistry(ModelEvent.RegisterGeometryLoaders event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"sophisticatedbackpacks", (String)BACKPACK_REG_NAME), (IGeometryLoader)BackpackDynamicModel.Loader.INSTANCE);
    }

    public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)resourceManager -> ClientEventHandler.registerBackpackLayer()));
    }

    private static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(ModItems.EVERLASTING_BACKPACK_ITEM_ENTITY.get(), ItemEntityRenderer::new);
        event.registerBlockEntityRenderer(ModBlocks.BACKPACK_TILE_TYPE.get(), context -> new BackpackBlockEntityRenderer());
    }

    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BACKPACK_LAYER, BackpackModel::createBodyLayer);
    }

    private static void registerBackpackLayer() {
        EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
        Map skinMap = renderManager.getSkinMap();
        for (EntityRenderer renderer : skinMap.values()) {
            if (!(renderer instanceof LivingEntityRenderer)) continue;
            LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
            livingEntityRenderer.addLayer(new BackpackLayerRenderer(livingEntityRenderer));
        }
        renderManager.renderers.forEach((e, r) -> {
            if (r instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)r;
                livingEntityRenderer.addLayer(new BackpackLayerRenderer(livingEntityRenderer));
            }
        });
    }

    public static void handleBlockPick(InputEvent.InteractionKeyMappingTriggered event) {
        BlockPos pos;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || player.isCreative() || !event.isPickBlock() || mc.hitResult == null || mc.hitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        HitResult target = mc.hitResult;
        Level level = player.level();
        BlockState state = level.getBlockState(pos = ((BlockHitResult)target).getBlockPos());
        if (state.isAir()) {
            return;
        }
        ItemStack result = state.getCloneItemStack(target, (LevelReader)level, pos, (Player)player);
        if (result.isEmpty() || player.getInventory().findSlotMatchingItem(result) > -1) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new BlockPickPayload(result), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void registerBackpackClientExtension(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private final Lazy<BlockEntityWithoutLevelRenderer> ister = Lazy.of(() -> new BackpackItemStackRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        }, new Item[]{(Item)ModItems.BACKPACK.get(), (Item)ModItems.COPPER_BACKPACK.get(), (Item)ModItems.IRON_BACKPACK.get(), (Item)ModItems.GOLD_BACKPACK.get(), (Item)ModItems.DIAMOND_BACKPACK.get(), (Item)ModItems.NETHERITE_BACKPACK.get()});
    }
}

