/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.codec;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import snownee.kiwi.RenderLayerEnum;
import snownee.kiwi.customization.block.loader.BlockCodecs;

public class CustomizationCodecs {
    public static final BiMap<String, NoteBlockInstrument> INSTRUMENTS = HashBiMap.create();
    public static final Codec<NoteBlockInstrument> INSTRUMENT_CODEC = CustomizationCodecs.simpleByNameCodec(INSTRUMENTS);
    public static final BiMap<String, MapColor> MAP_COLORS = HashBiMap.create();
    public static final Codec<MapColor> MAP_COLOR_CODEC = CustomizationCodecs.simpleByNameCodec(MAP_COLORS);
    public static final Codec<PushReaction> PUSH_REACTION = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"normal", (Object)PushReaction.NORMAL, (Object)"destroy", (Object)PushReaction.DESTROY, (Object)"block", (Object)PushReaction.BLOCK, (Object)"ignore", (Object)PushReaction.IGNORE, (Object)"push_only", (Object)PushReaction.PUSH_ONLY));
    public static final Codec<RenderLayerEnum> RENDER_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"cutout", (Object)((Object)RenderLayerEnum.CUTOUT), (Object)"cutout_mipped", (Object)((Object)RenderLayerEnum.CUTOUT_MIPPED), (Object)"translucent", (Object)((Object)RenderLayerEnum.TRANSLUCENT)));
    public static final Codec<BlockBehaviour.OffsetType> OFFSET_TYPE = CustomizationCodecs.simpleByNameCodec(ImmutableBiMap.of((Object)"xz", (Object)BlockBehaviour.OffsetType.XZ, (Object)"xyz", (Object)BlockBehaviour.OffsetType.XYZ));
    public static final Codec<BlockBehaviour.StatePredicate> STATE_PREDICATE = Codec.BOOL.flatComapMap(bl -> bl != false ? Blocks::always : Blocks::never, p -> DataResult.error(() -> "Unsupported operation"));
    public static final Codec<TreeGrower> TREE_GROWER = Codec.withAlternative((Codec)TreeGrower.CODEC, (Codec)RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(BlockCodecs::notImplemented), (App)Codec.FLOAT.optionalFieldOf("secondary_chance", (Object)Float.valueOf(0.0f)).forGetter(BlockCodecs::notImplemented), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).optionalFieldOf("mega_tree").forGetter(BlockCodecs::notImplemented), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).optionalFieldOf("secondary_mega_tree").forGetter(BlockCodecs::notImplemented), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).optionalFieldOf("tree").forGetter(BlockCodecs::notImplemented), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).optionalFieldOf("secondary_tree").forGetter(BlockCodecs::notImplemented), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).optionalFieldOf("flowers").forGetter(BlockCodecs::notImplemented), (App)ResourceKey.codec((ResourceKey)Registries.CONFIGURED_FEATURE).optionalFieldOf("secondary_flowers").forGetter(BlockCodecs::notImplemented)).apply((Applicative)instance, TreeGrower::new)));
    public static final Codec<BlockPredicate> BLOCK_PREDICATE = new Codec<BlockPredicate>(){

        public <T> DataResult<Pair<BlockPredicate, T>> decode(DynamicOps<T> ops, T input) {
            String stringValue = ops.getStringValue(input).result().orElse(null);
            if (stringValue != null) {
                if (stringValue.startsWith("#")) {
                    return DataResult.success((Object)Pair.of((Object)BlockPredicate.Builder.block().of(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)stringValue.substring(1)))).build(), (Object)ops.empty()));
                }
                return DataResult.success((Object)Pair.of((Object)BlockPredicate.Builder.block().of(new Block[]{(Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)stringValue))}).build(), (Object)ops.empty()));
            }
            return DataResult.error(() -> "Raw JSON input is not supported");
        }

        public <T> DataResult<T> encode(BlockPredicate input, DynamicOps<T> ops, T prefix) {
            return DataResult.error(() -> "Not supported yet");
        }
    };

    public static <T> Codec<T> simpleByNameCodec(Map<ResourceLocation, T> map) {
        return ResourceLocation.CODEC.flatXmap(key -> {
            Object value = map.get(key);
            if (value == null) {
                return DataResult.error(() -> "Unknown key: " + String.valueOf(key));
            }
            return DataResult.success(value);
        }, value -> DataResult.error(() -> "Unsupported operation"));
    }

    public static <T> Codec<T> simpleByNameCodec(BiMap<String, T> map) {
        return CustomizationCodecs.simpleByNameCodec(map, Codec.STRING);
    }

    public static <K, V> Codec<V> simpleByNameCodec(BiMap<K, V> map, Codec<K> keyCodec) {
        return keyCodec.flatXmap(key -> {
            Object value = map.get(key);
            if (value == null) {
                return DataResult.error(() -> "Unknown key: " + String.valueOf(key));
            }
            return DataResult.success((Object)value);
        }, value -> {
            Object key = map.inverse().get(value);
            if (key == null) {
                return DataResult.error(() -> "Unknown value: " + String.valueOf(value));
            }
            return DataResult.success((Object)key);
        });
    }

    public static <T> Codec<BlockBehaviour.StateArgumentPredicate<T>> stateArgumentPredicate() {
        return new Codec<BlockBehaviour.StateArgumentPredicate<T>>(){

            public <R> DataResult<R> encode(BlockBehaviour.StateArgumentPredicate<T> input, DynamicOps<R> ops, R prefix) {
                return DataResult.error(() -> "Unsupported operation");
            }

            public <R> DataResult<Pair<BlockBehaviour.StateArgumentPredicate<T>, R>> decode(DynamicOps<R> ops, R input) {
                String s;
                Optional booleanValue = ops.getBooleanValue(input).result();
                if (booleanValue.isPresent()) {
                    BlockBehaviour.StateArgumentPredicate predicate = (Boolean)booleanValue.get() != false ? CustomizationCodecs::always : CustomizationCodecs::never;
                    return DataResult.success((Object)Pair.of((Object)predicate, (Object)ops.empty()));
                }
                Optional stringValue = ops.getStringValue(input).result();
                if (stringValue.isPresent() && "ocelot_or_parrot".equals(s = (String)stringValue.get())) {
                    return DataResult.success((Object)Pair.of((state, world, pos, entity) -> entity == EntityType.OCELOT || entity == EntityType.PARROT, (Object)ops.empty()));
                }
                return DataResult.error(() -> "Failed to decode state argument predicate: " + String.valueOf(input));
            }
        };
    }

    public static <T> boolean always(BlockState blockState, BlockGetter blockGetter, BlockPos pos, T t) {
        return true;
    }

    public static <T> boolean never(BlockState blockState, BlockGetter blockGetter, BlockPos pos, T t) {
        return false;
    }

    static {
        MAP_COLORS.put((Object)"none", (Object)MapColor.NONE);
        MAP_COLORS.put((Object)"grass", (Object)MapColor.GRASS);
        MAP_COLORS.put((Object)"sand", (Object)MapColor.SAND);
        MAP_COLORS.put((Object)"wool", (Object)MapColor.WOOL);
        MAP_COLORS.put((Object)"fire", (Object)MapColor.FIRE);
        MAP_COLORS.put((Object)"ice", (Object)MapColor.ICE);
        MAP_COLORS.put((Object)"metal", (Object)MapColor.METAL);
        MAP_COLORS.put((Object)"plant", (Object)MapColor.PLANT);
        MAP_COLORS.put((Object)"snow", (Object)MapColor.SNOW);
        MAP_COLORS.put((Object)"clay", (Object)MapColor.CLAY);
        MAP_COLORS.put((Object)"dirt", (Object)MapColor.DIRT);
        MAP_COLORS.put((Object)"stone", (Object)MapColor.STONE);
        MAP_COLORS.put((Object)"water", (Object)MapColor.WATER);
        MAP_COLORS.put((Object)"wood", (Object)MapColor.WOOD);
        MAP_COLORS.put((Object)"quartz", (Object)MapColor.QUARTZ);
        MAP_COLORS.put((Object)"color_orange", (Object)MapColor.COLOR_ORANGE);
        MAP_COLORS.put((Object)"color_magenta", (Object)MapColor.COLOR_MAGENTA);
        MAP_COLORS.put((Object)"color_light_blue", (Object)MapColor.COLOR_LIGHT_BLUE);
        MAP_COLORS.put((Object)"color_yellow", (Object)MapColor.COLOR_YELLOW);
        MAP_COLORS.put((Object)"color_light_green", (Object)MapColor.COLOR_LIGHT_GREEN);
        MAP_COLORS.put((Object)"color_pink", (Object)MapColor.COLOR_PINK);
        MAP_COLORS.put((Object)"color_gray", (Object)MapColor.COLOR_GRAY);
        MAP_COLORS.put((Object)"color_light_gray", (Object)MapColor.COLOR_LIGHT_GRAY);
        MAP_COLORS.put((Object)"color_cyan", (Object)MapColor.COLOR_CYAN);
        MAP_COLORS.put((Object)"color_purple", (Object)MapColor.COLOR_PURPLE);
        MAP_COLORS.put((Object)"color_blue", (Object)MapColor.COLOR_BLUE);
        MAP_COLORS.put((Object)"color_brown", (Object)MapColor.COLOR_BROWN);
        MAP_COLORS.put((Object)"color_green", (Object)MapColor.COLOR_GREEN);
        MAP_COLORS.put((Object)"color_red", (Object)MapColor.COLOR_RED);
        MAP_COLORS.put((Object)"color_black", (Object)MapColor.COLOR_BLACK);
        MAP_COLORS.put((Object)"gold", (Object)MapColor.GOLD);
        MAP_COLORS.put((Object)"diamond", (Object)MapColor.DIAMOND);
        MAP_COLORS.put((Object)"lapis", (Object)MapColor.LAPIS);
        MAP_COLORS.put((Object)"emerald", (Object)MapColor.EMERALD);
        MAP_COLORS.put((Object)"podzol", (Object)MapColor.PODZOL);
        MAP_COLORS.put((Object)"nether", (Object)MapColor.NETHER);
        MAP_COLORS.put((Object)"terracotta_white", (Object)MapColor.TERRACOTTA_WHITE);
        MAP_COLORS.put((Object)"terracotta_orange", (Object)MapColor.TERRACOTTA_ORANGE);
        MAP_COLORS.put((Object)"terracotta_magenta", (Object)MapColor.TERRACOTTA_MAGENTA);
        MAP_COLORS.put((Object)"terracotta_light_blue", (Object)MapColor.TERRACOTTA_LIGHT_BLUE);
        MAP_COLORS.put((Object)"terracotta_yellow", (Object)MapColor.TERRACOTTA_YELLOW);
        MAP_COLORS.put((Object)"terracotta_light_green", (Object)MapColor.TERRACOTTA_LIGHT_GREEN);
        MAP_COLORS.put((Object)"terracotta_pink", (Object)MapColor.TERRACOTTA_PINK);
        MAP_COLORS.put((Object)"terracotta_gray", (Object)MapColor.TERRACOTTA_GRAY);
        MAP_COLORS.put((Object)"terracotta_light_gray", (Object)MapColor.TERRACOTTA_LIGHT_GRAY);
        MAP_COLORS.put((Object)"terracotta_cyan", (Object)MapColor.TERRACOTTA_CYAN);
        MAP_COLORS.put((Object)"terracotta_purple", (Object)MapColor.TERRACOTTA_PURPLE);
        MAP_COLORS.put((Object)"terracotta_blue", (Object)MapColor.TERRACOTTA_BLUE);
        MAP_COLORS.put((Object)"terracotta_brown", (Object)MapColor.TERRACOTTA_BROWN);
        MAP_COLORS.put((Object)"terracotta_green", (Object)MapColor.TERRACOTTA_GREEN);
        MAP_COLORS.put((Object)"terracotta_red", (Object)MapColor.TERRACOTTA_RED);
        MAP_COLORS.put((Object)"terracotta_black", (Object)MapColor.TERRACOTTA_BLACK);
        MAP_COLORS.put((Object)"crimson_nylium", (Object)MapColor.CRIMSON_NYLIUM);
        MAP_COLORS.put((Object)"crimson_stem", (Object)MapColor.CRIMSON_STEM);
        MAP_COLORS.put((Object)"crimson_hyphae", (Object)MapColor.CRIMSON_HYPHAE);
        MAP_COLORS.put((Object)"warped_nylium", (Object)MapColor.WARPED_NYLIUM);
        MAP_COLORS.put((Object)"warped_stem", (Object)MapColor.WARPED_STEM);
        MAP_COLORS.put((Object)"warped_hyphae", (Object)MapColor.WARPED_HYPHAE);
        MAP_COLORS.put((Object)"warped_wart_block", (Object)MapColor.WARPED_WART_BLOCK);
        MAP_COLORS.put((Object)"deepslate", (Object)MapColor.DEEPSLATE);
        MAP_COLORS.put((Object)"raw_iron", (Object)MapColor.RAW_IRON);
        MAP_COLORS.put((Object)"glow_lichen", (Object)MapColor.GLOW_LICHEN);
        for (NoteBlockInstrument instrument : NoteBlockInstrument.values()) {
            if (!instrument.isTunable()) continue;
            INSTRUMENTS.put((Object)instrument.getSerializedName(), (Object)instrument);
        }
    }
}

