/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.shadowed.com.ezylang.evalex.data.conversion;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import snownee.kiwi.shadowed.com.ezylang.evalex.config.ExpressionConfiguration;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.EvaluationValue;
import snownee.kiwi.shadowed.com.ezylang.evalex.data.conversion.ConverterIfc;

public class ArrayConverter
implements ConverterIfc {
    @Override
    public EvaluationValue convert(Object object, ExpressionConfiguration configuration) {
        List<EvaluationValue> list;
        if (object.getClass().isArray()) {
            list = this.convertArray(object, configuration);
        } else if (object instanceof List) {
            list = ArrayConverter.convertList((List)object, configuration);
        } else {
            throw this.illegalArgument(object);
        }
        return EvaluationValue.arrayValue(list);
    }

    @Override
    public boolean canConvert(Object object) {
        return object instanceof List || object.getClass().isArray();
    }

    private static List<EvaluationValue> convertList(List<?> object, ExpressionConfiguration configuration) {
        return object.stream().map(element -> EvaluationValue.of(element, configuration)).collect(Collectors.toList());
    }

    private List<EvaluationValue> convertArray(Object array, ExpressionConfiguration configuration) {
        if (array instanceof int[]) {
            return this.convertIntArray((int[])array, configuration);
        }
        if (array instanceof long[]) {
            return this.convertLongArray((long[])array, configuration);
        }
        if (array instanceof double[]) {
            return this.convertDoubleArray((double[])array, configuration);
        }
        if (array instanceof float[]) {
            return this.convertFloatArray((float[])array, configuration);
        }
        if (array instanceof short[]) {
            return this.convertShortArray((short[])array, configuration);
        }
        if (array instanceof char[]) {
            return this.convertCharArray((char[])array, configuration);
        }
        if (array instanceof byte[]) {
            return this.convertByteArray((byte[])array, configuration);
        }
        if (array instanceof boolean[]) {
            return this.convertBooleanArray((boolean[])array, configuration);
        }
        return this.convertObjectArray((Object[])array, configuration);
    }

    private List<EvaluationValue> convertIntArray(int[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (int i : array) {
            list.add(EvaluationValue.of(i, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertLongArray(long[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (long l : array) {
            list.add(EvaluationValue.of(l, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertDoubleArray(double[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (double d : array) {
            list.add(EvaluationValue.of(d, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertFloatArray(float[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (float f : array) {
            list.add(EvaluationValue.of(Float.valueOf(f), configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertShortArray(short[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (short s : array) {
            list.add(EvaluationValue.of(s, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertCharArray(char[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (char c : array) {
            list.add(EvaluationValue.of(Character.valueOf(c), configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertByteArray(byte[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (byte b : array) {
            list.add(EvaluationValue.of(b, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertBooleanArray(boolean[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (boolean b : array) {
            list.add(EvaluationValue.of(b, configuration));
        }
        return list;
    }

    private List<EvaluationValue> convertObjectArray(Object[] array, ExpressionConfiguration configuration) {
        ArrayList<EvaluationValue> list = new ArrayList<EvaluationValue>();
        for (Object o : array) {
            list.add(EvaluationValue.of(o, configuration));
        }
        return list;
    }
}

