/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import snownee.kiwi.data.DataModule;

public class NoContainersShapedRecipe
extends ShapedRecipe {
    private final boolean noContainers;

    public NoContainersShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification, boolean noContainers) {
        super(group, category, pattern, result, showNotification);
        this.noContainers = noContainers;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        return NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
    }

    public RecipeSerializer<?> getSerializer() {
        return DataModule.SHAPED_NO_CONTAINERS.get();
    }

    public boolean noContainers() {
        return this.noContainers;
    }

    public static class Serializer
    implements RecipeSerializer<NoContainersShapedRecipe> {
        public static final MapCodec<NoContainersShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(shapedRecipe -> shapedRecipe.pattern), (App)ItemStack.CODEC.fieldOf("result").forGetter(shapedRecipe -> shapedRecipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(ShapedRecipe::showNotification), (App)Codec.BOOL.fieldOf("no_containers").orElse((Object)false).forGetter(NoContainersShapedRecipe::noContainers)).apply((Applicative)instance, NoContainersShapedRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, NoContainersShapedRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<NoContainersShapedRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, NoContainersShapedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static NoContainersShapedRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.streamCodec().decode((Object)buffer);
            boolean noContainers = buffer.readBoolean();
            return new NoContainersShapedRecipe(recipe.getGroup(), recipe.category(), recipe.pattern, recipe.result, recipe.showNotification(), noContainers);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, NoContainersShapedRecipe recipe) {
            RecipeSerializer.SHAPED_RECIPE.streamCodec().encode((Object)buffer, (Object)recipe);
            buffer.writeBoolean(recipe.noContainers);
        }
    }
}

