/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicShapedRecipe
extends CustomRecipe {
    protected ShapedRecipePattern pattern;
    protected String rawPattern;
    protected boolean differentInputs;
    protected boolean showNotification;
    protected ItemStack result;
    protected String group;

    public DynamicShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification, boolean differentInputs) {
        super(category);
        this.group = group;
        this.pattern = pattern;
        this.rawPattern = String.join((CharSequence)"", ((ShapedRecipePattern.Data)pattern.data.orElseThrow()).pattern());
        this.result = result;
        this.showNotification = showNotification;
        this.differentInputs = differentInputs;
    }

    public DynamicShapedRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level worldIn) {
        return this.search(input) != null;
    }

    public int @Nullable [] search(CraftingInput input) {
        for (int x = 0; x <= input.width() - this.getWidth(); ++x) {
            for (int y = 0; y <= input.height() - this.getHeight(); ++y) {
                if (!this.checkMatch(input, x, y) || !this.checkEmpty(input, x, y)) continue;
                return new int[]{x, y};
            }
        }
        return null;
    }

    public ItemStack item(char key, CraftingInput inv, int[] matchPos) {
        int i = this.rawPattern.indexOf(key);
        if (i != -1) {
            int x = matchPos[0] + i % this.getWidth();
            int y = matchPos[1] + i / this.getWidth();
            return inv.getItem(x + y * inv.width());
        }
        return ItemStack.EMPTY;
    }

    public List<ItemStack> items(char key, CraftingInput inv, int[] matchPos) {
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < this.rawPattern.length(); ++i) {
            if (key != this.rawPattern.charAt(i)) continue;
            int x = matchPos[0] + i % this.getWidth();
            int y = matchPos[1] + i / this.getWidth();
            items.add(inv.getItem(x + y * inv.width()));
        }
        return items;
    }

    public abstract ItemStack assemble(CraftingInput var1, HolderLookup.Provider var2);

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.getWidth() && height >= this.getHeight();
    }

    public String getGroup() {
        return this.group;
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public ItemStack result() {
        return this.result;
    }

    public ShapedRecipePattern pattern() {
        return this.pattern;
    }

    public boolean allowDifferentInputs() {
        return this.differentInputs;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public abstract RecipeSerializer<?> getSerializer();

    protected boolean checkMatch(CraftingInput input, int startX, int startY) {
        Char2ObjectArrayMap ingredientsArrayMap = null;
        if (!this.differentInputs) {
            ingredientsArrayMap = new Char2ObjectArrayMap();
        }
        for (int y = startY; y < startY + this.getHeight(); ++y) {
            for (int x = startX; x < startX + this.getWidth(); ++x) {
                int i;
                char key;
                int rx = x - startX;
                int ry = y - startY;
                if (!this.matches(input, x, y, rx, ry)) {
                    return false;
                }
                if (this.differentInputs || (key = this.rawPattern.charAt(i = rx + ry * this.getWidth())) == ' ') continue;
                ItemStack stack0 = input.getItem(x + y * input.width());
                ItemStack stack1 = (ItemStack)ingredientsArrayMap.get(key);
                if (stack1 == null) {
                    ingredientsArrayMap.put(key, (Object)stack0);
                    continue;
                }
                if (ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matches(CraftingInput inv, int x, int y, int rx, int ry) {
        Ingredient ingredient = (Ingredient)this.getIngredients().get(rx + ry * this.getWidth());
        return ingredient.test(inv.getItem(x + y * inv.width()));
    }

    protected boolean checkEmpty(CraftingInput inv, int startX, int startY) {
        for (int y = 0; y < inv.height(); ++y) {
            int subY = y - startY;
            for (int x = 0; x < inv.width(); ++x) {
                int subX = x - startX;
                if (subX >= 0 && subY >= 0 && subX < this.getWidth() && subY < this.getHeight() || this.getEmptyPredicate().test(inv.getItem(x + y * inv.width()))) continue;
                return false;
            }
        }
        return true;
    }

    protected Predicate<ItemStack> getEmptyPredicate() {
        return Ingredient.EMPTY;
    }

    public static abstract class Serializer<T extends DynamicShapedRecipe>
    implements RecipeSerializer<T> {
        public static <T extends DynamicShapedRecipe> T fromNetwork(Function<CraftingBookCategory, T> constructor, RegistryFriendlyByteBuf buffer) {
            DynamicShapedRecipe recipe = (DynamicShapedRecipe)((Object)constructor.apply((CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class)));
            recipe.group = buffer.readUtf(256);
            recipe.result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            recipe.pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            recipe.differentInputs = buffer.readBoolean();
            return (T)((Object)recipe);
        }

        public static <T extends DynamicShapedRecipe> void toNetwork(RegistryFriendlyByteBuf buffer, T recipe) {
            buffer.writeEnum((Enum)recipe.category());
            buffer.writeUtf(recipe.getGroup(), 256);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            recipe.rawPattern = String.join((CharSequence)"", ((ShapedRecipePattern.Data)recipe.pattern.data.orElseThrow()).pattern());
            buffer.writeBoolean(recipe.differentInputs);
        }
    }
}

