/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.network;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public final class KPacketSender {
    private KPacketSender() {
    }

    public static void sendToTracking(CustomPacketPayload payload, Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToTracking(CustomPacketPayload payload, BlockEntity blockEntity) {
        KPacketSender.sendToTracking(payload, (ServerLevel)blockEntity.getLevel(), blockEntity.getBlockPos());
    }

    public static void sendToTracking(CustomPacketPayload payload, ServerLevel level, ChunkPos chunkPos) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)chunkPos, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToTracking(CustomPacketPayload payload, ServerLevel level, BlockPos blockPos) {
        KPacketSender.sendToTracking(payload, level, new ChunkPos(blockPos));
    }

    public static void sendToWorld(CustomPacketPayload payload, ServerLevel level) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAll(CustomPacketPayload payload, MinecraftServer server) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Deprecated
    public static void sendToAllExcept(CustomPacketPayload payload, ServerPlayer player) {
        KPacketSender.sendToAll(payload, player.server);
    }

    public static void sendToAround(CustomPacketPayload payload, ServerLevel world, @Nullable ServerPlayer excluded, Vec3 pos, double radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)world, (ServerPlayer)excluded, (double)pos.x, (double)pos.y, (double)pos.z, (double)radius, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAround(CustomPacketPayload payload, ServerLevel world, @Nullable ServerPlayer excluded, Vec3i pos, double radius) {
        PacketDistributor.sendToPlayersNear((ServerLevel)world, (ServerPlayer)excluded, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)radius, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void send(CustomPacketPayload payload, Player player) {
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void send(CustomPacketPayload payload, Stream<ServerPlayer> players) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(payload);
        players.forEach(p -> p.connection.send((Packet)packet));
    }

    public static void sendToServer(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

