/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.mixin.customization;

import com.google.common.collect.Sets;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import snownee.kiwi.customization.CustomizationHooks;

@Mixin(value={BlockEntityType.class})
public abstract class BlockEntityTypeMixin {
    @Shadow
    @Final
    private Set<Block> validBlocks;
    @Unique
    private Boolean lenient;
    @Unique
    private volatile Set<Block> lenientValidBlocks;

    @Shadow
    @Nullable
    public abstract Holder.Reference<BlockEntityType<?>> builtInRegistryHolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"isValid"}, at={@At(value="INVOKE", target="Ljava/util/Set;contains(Ljava/lang/Object;)Z")})
    public boolean isValid(Set<Block> instance, Object object, Operation<Boolean> original) {
        if (!CustomizationHooks.isEnabled()) {
            return (Boolean)original.call(new Object[]{instance, object});
        }
        if (object == null) {
            return false;
        }
        if (this.lenientValidBlocks != null && this.lenientValidBlocks.contains(object)) {
            return true;
        }
        if (((Boolean)original.call(new Object[]{instance, object})).booleanValue()) {
            return true;
        }
        if (this.lenient == null) {
            Holder.Reference<BlockEntityType<?>> reference = this.builtInRegistryHolder();
            if (reference == null) {
                return false;
            }
            ResourceLocation key = reference.key().location();
            this.lenient = CustomizationHooks.getLenientBETypeNamespaces().contains(key.getNamespace());
        }
        if (this.lenient == Boolean.FALSE) {
            return false;
        }
        for (Block validBlock : this.validBlocks) {
            if (validBlock.getClass() != object.getClass()) continue;
            if (this.lenientValidBlocks == null) {
                Set<Block> set = this.validBlocks;
                synchronized (set) {
                    if (this.lenientValidBlocks == null) {
                        this.lenientValidBlocks = Sets.newHashSet(this.validBlocks);
                    }
                }
            }
            this.lenientValidBlocks.add((Block)object);
            return true;
        }
        return false;
    }
}

