/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.util.codec.KCodecs;

public record StatePropertiesPredicate(List<PropertyMatcher> properties) implements Predicate<BlockState>
{
    public static final Codec<StatePropertiesPredicate> CODEC = Codec.compoundList((Codec)Codec.STRING, (Codec)Codec.either(KCodecs.compactList(Codec.STRING), (Codec)MinMaxBounds.Ints.CODEC)).xmap($ -> new StatePropertiesPredicate($.stream().map(pair -> {
        Optional strValues = ((Either)pair.getSecond()).left();
        return strValues.map(strings -> new PropertyMatcher((String)pair.getFirst(), (Either<Set<String>, MinMaxBounds.Ints>)Either.left(Set.copyOf(strings)))).orElseGet(() -> new PropertyMatcher((String)pair.getFirst(), (Either<Set<String>, MinMaxBounds.Ints>)Either.right((Object)((MinMaxBounds.Ints)((Either)pair.getSecond()).right().orElseThrow()))));
    }).toList()), $ -> $.properties.stream().map(matcher -> Pair.of((Object)matcher.key, (Object)matcher.value.mapLeft(List::copyOf))).toList());

    @Override
    public boolean test(BlockState blockState) {
        for (PropertyMatcher matcher : this.properties) {
            if (matcher.test(blockState)) continue;
            return false;
        }
        return true;
    }

    public boolean smartTest(BlockState baseState, BlockState targetState) {
        for (PropertyMatcher matcher : this.properties) {
            if (matcher.smartTest(baseState, targetState)) continue;
            return false;
        }
        return true;
    }

    public record PropertyMatcher(String key, Either<Set<String>, MinMaxBounds.Ints> value) {
        public boolean test(BlockState blockState) {
            boolean isInteger;
            Property<?> property = KBlockUtils.getProperty(blockState, this.key);
            Optional strValues = this.value.left();
            boolean bl = isInteger = property.getValueClass() == Integer.class;
            if (strValues.isEmpty() && !isInteger) {
                throw new IllegalStateException("Property value type mismatch");
            }
            if (strValues.isEmpty()) {
                return ((MinMaxBounds.Ints)this.value.right().orElseThrow()).matches(((Integer)blockState.getValue(property)).intValue());
            }
            return ((Set)strValues.get()).contains(KBlockUtils.getValueString(blockState, this.key));
        }

        public boolean smartTest(BlockState baseState, BlockState targetState) {
            boolean isInteger;
            Property<?> property = KBlockUtils.getProperty(targetState, this.key);
            Optional strValues = this.value.left();
            boolean bl = isInteger = property.getValueClass() == Integer.class;
            if (strValues.isEmpty() && !isInteger) {
                throw new IllegalStateException("Property value type mismatch");
            }
            if (strValues.isEmpty()) {
                return ((MinMaxBounds.Ints)this.value.right().orElseThrow()).matches(((Integer)targetState.getValue(property)).intValue());
            }
            String targetValue = KBlockUtils.getValueString(targetState, this.key);
            for (String s : (Set)strValues.get()) {
                String baseValue;
                if (!(s.startsWith("@") ? (baseValue = KBlockUtils.getValueString(baseState, s.substring(1))).equals(targetValue) : s.equals(targetValue))) continue;
                return true;
            }
            return false;
        }
    }
}

