/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.duck.KBlockProperties;
import snownee.kiwi.customization.item.MultipleBlockItem;
import snownee.kiwi.customization.placement.ParsedProtoTag;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.customization.placement.PlaceTarget;
import snownee.kiwi.customization.placement.SlotLink;
import snownee.kiwi.customization.placement.StatePropertiesPredicate;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.BlockPredicateHelper;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.KUtil;
import snownee.kiwi.util.codec.CustomizationCodecs;
import snownee.kiwi.util.codec.KCodecs;

public record PlaceChoices(List<PlaceTarget> target, Optional<String> transformWith, List<Flow> flow, List<Alter> alter, List<Limit> limit, List<Interests> interests, boolean skippable) {
    public static final BiMap<String, BlockFaceType> BLOCK_FACE_TYPES = HashBiMap.create();
    public static final Codec<PlaceChoices> CODEC;

    public static void setTo(Block block, @Nullable KHolder<PlaceChoices> holder) {
        KBlockSettings settings = KBlockSettings.of(block);
        if (settings == null && holder != null) {
            settings = KBlockSettings.empty();
            ((KBlockProperties)block.properties()).kiwi$setSettings(settings);
        }
        if (settings != null) {
            settings.placeChoices = holder == null ? null : holder.value();
        }
    }

    public int test(BlockState baseState, BlockState targetState) {
        for (Limit limit : this.limit) {
            if (limit.test(baseState, targetState)) continue;
            return Integer.MIN_VALUE;
        }
        int interest = 0;
        for (Interests provider : this.interests) {
            if (!provider.when().smartTest(baseState, targetState)) continue;
            interest += provider.bonus;
        }
        return interest;
    }

    public BlockState getStateForPlacement(Level level, BlockPos pos, BlockState original) {
        if (this.flow.isEmpty()) {
            return original;
        }
        MutableObject rotation = new MutableObject((Object)Rotation.NONE);
        String transformWith = this.transformWith.orElse("none");
        if (!transformWith.equals("none")) {
            Property<?> property = KBlockUtils.getProperty(original, transformWith);
            if (!(property instanceof DirectionProperty)) {
                throw new IllegalArgumentException("Invalid transform_with property: " + transformWith);
            }
            DirectionProperty directionProperty = (DirectionProperty)property;
            Direction direction = (Direction)original.getValue((Property)directionProperty);
            for (Rotation r : Rotation.values()) {
                if (r.rotate(Direction.NORTH) != direction) continue;
                rotation.setValue((Object)r);
                break;
            }
        }
        BlockState blockState = original;
        BlockPos.MutableBlockPos mutable = pos.mutable();
        block3: for (Flow f : this.flow) {
            for (Map.Entry<Direction, Limit> entry : f.when.entrySet()) {
                Direction direction = ((Rotation)rotation.getValue()).rotate(entry.getKey());
                try {
                    if (entry.getValue().testFace(level.getBlockState((BlockPos)mutable.setWithOffset((Vec3i)pos, direction)), direction.getOpposite())) continue;
                }
                catch (Exception e) {}
                continue block3;
            }
            blockState = f.action.apply(level, (BlockPos)mutable, blockState);
            if (!f.end) continue;
            break;
        }
        return blockState;
    }

    static {
        BLOCK_FACE_TYPES.put((Object)"any", (Object)BlockFaceType.ANY);
        BLOCK_FACE_TYPES.put((Object)"horizontal", (Object)BlockFaceType.HORIZONTAL);
        BLOCK_FACE_TYPES.put((Object)"vertical", (Object)BlockFaceType.VERTICAL);
        BLOCK_FACE_TYPES.put((Object)"clicked_face", (context, direction) -> context.getClickedFace() == direction.getOpposite());
        for (Direction direction2 : KUtil.DIRECTIONS) {
            BLOCK_FACE_TYPES.put((Object)direction2.getSerializedName(), (context, dir) -> dir == direction2);
        }
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)KCodecs.compactList(PlaceTarget.CODEC).fieldOf("target").forGetter(PlaceChoices::target), (App)Codec.STRING.optionalFieldOf("transform_with").forGetter(PlaceChoices::transformWith), (App)KCodecs.compactList(Flow.CODEC).optionalFieldOf("flow", List.of()).forGetter(PlaceChoices::flow), (App)KCodecs.compactList(Alter.CODEC).optionalFieldOf("alter", List.of()).forGetter(PlaceChoices::alter), (App)KCodecs.compactList(Limit.CODEC).optionalFieldOf("limit", List.of()).forGetter(PlaceChoices::limit), (App)KCodecs.compactList(Interests.CODEC).optionalFieldOf("interests", List.of()).forGetter(PlaceChoices::interests), (App)Codec.BOOL.optionalFieldOf("skippable", (Object)true).forGetter(PlaceChoices::skippable)).apply((Applicative)instance, PlaceChoices::new));
    }

    public record Limit(String type, List<ParsedProtoTag> tags) {
        public static final Codec<Limit> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(Limit::type), (App)KCodecs.compactList(ParsedProtoTag.CODEC).fieldOf("tags").forGetter(Limit::tags)).apply((Applicative)instance, Limit::new));

        public boolean test(BlockState baseState, BlockState targetState) {
            for (ParsedProtoTag tag : this.tags) {
                boolean pass;
                ParsedProtoTag resolvedTag = tag.resolve(baseState, Rotation.NONE);
                if (pass = (switch (this.type) {
                    case "has_tags" -> {
                        for (Direction direction : KUtil.DIRECTIONS) {
                            Collection<PlaceSlot> slots = PlaceSlot.find(targetState, direction);
                            for (PlaceSlot slot : slots) {
                                if (!slot.hasTag(resolvedTag)) continue;
                                yield true;
                            }
                        }
                        yield false;
                    }
                    default -> false;
                })) continue;
                return false;
            }
            return true;
        }

        public boolean testFace(BlockState blockState, Direction direction) {
            Collection<PlaceSlot> slots = PlaceSlot.find(blockState, direction);
            for (ParsedProtoTag tag : this.tags) {
                boolean pass;
                ParsedProtoTag resolvedTag = tag.resolve(blockState, Rotation.NONE);
                if (pass = (switch (this.type) {
                    case "has_tags" -> {
                        for (PlaceSlot slot : slots) {
                            if (!slot.hasTag(resolvedTag)) continue;
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                })) continue;
                return false;
            }
            return true;
        }
    }

    public record Interests(StatePropertiesPredicate when, int bonus) {
        public static final Codec<Interests> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StatePropertiesPredicate.CODEC.fieldOf("when").forGetter(Interests::when), (App)Codec.INT.fieldOf("bonus").forGetter(Interests::bonus)).apply((Applicative)instance, Interests::new));
    }

    public record Flow(Map<Direction, Limit> when, SlotLink.ResultAction action, boolean end) {
        public static final Codec<Flow> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Direction.CODEC, Limit.CODEC).fieldOf("when").forGetter(Flow::when), (App)SlotLink.ResultAction.MAP_CODEC.forGetter(Flow::action), (App)Codec.BOOL.optionalFieldOf("end", (Object)false).forGetter(Flow::end)).apply((Applicative)instance, Flow::new));
    }

    public record Alter(List<AlterCondition> when, String use) {
        public static final Codec<Alter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.nonEmptyList(KCodecs.compactList(AlterCondition.CODEC)).fieldOf("when").forGetter(Alter::when), (App)Codec.STRING.fieldOf("use").forGetter(Alter::use)).apply((Applicative)instance, Alter::new));

        @Nullable
        public BlockState alter(BlockItem blockItem, BlockPlaceContext context) {
            if (!(blockItem instanceof MultipleBlockItem)) {
                return null;
            }
            MultipleBlockItem multipleBlockItem = (MultipleBlockItem)blockItem;
            for (AlterCondition condition : this.when) {
                if (!condition.test(context)) continue;
                Block block = multipleBlockItem.getBlock(this.use);
                Preconditions.checkNotNull((Object)block, (String)"Block %s not found in %s", (Object)this.use, (Object)((Object)multipleBlockItem));
                Preconditions.checkState((block != blockItem.getBlock() ? 1 : 0) != 0, (String)"Block %s is the same as the original block, dead loop detected", (Object)block);
                BlockState blockState = block.getStateForPlacement(context);
                if (blockState == null) {
                    return null;
                }
                KBlockSettings settings = KBlockSettings.of(block);
                if (settings != null) {
                    blockState = settings.getStateForPlacement(blockState, context);
                }
                return blockState;
            }
            return null;
        }
    }

    public static interface BlockFaceType
    extends BiPredicate<UseOnContext, Direction> {
        public static final BlockFaceType ANY = (context, direction) -> true;
        public static final BlockFaceType HORIZONTAL = (context, direction) -> direction.getAxis().isHorizontal();
        public static final BlockFaceType VERTICAL = (context, direction) -> direction.getAxis().isVertical();
    }

    public record AlterCondition(String target, BlockFaceType faces, BlockPredicate block, List<ParsedProtoTag> tags) {
        public static final Codec<AlterCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("target", (Object)"neighbor").forGetter(AlterCondition::target), (App)CustomizationCodecs.simpleByNameCodec(BLOCK_FACE_TYPES).optionalFieldOf("faces", (Object)BlockFaceType.ANY).forGetter(AlterCondition::faces), (App)CustomizationCodecs.BLOCK_PREDICATE.optionalFieldOf("block", (Object)BlockPredicateHelper.ANY).forGetter(AlterCondition::block), (App)KCodecs.compactList(ParsedProtoTag.CODEC).optionalFieldOf("tags", List.of()).forGetter(AlterCondition::tags)).apply((Applicative)instance, AlterCondition::new));

        public boolean test(BlockPlaceContext context) {
            List<Direction> directions = switch (this.target) {
                case "clicked_face" -> List.of(context.getClickedFace().getOpposite());
                case "neighbor" -> KUtil.DIRECTIONS;
                default -> throw new IllegalStateException("Unexpected value: " + this.target);
            };
            BlockPos pos = context.getClickedPos();
            BlockPos.MutableBlockPos mutable = pos.mutable();
            block8: for (Direction direction : directions) {
                BlockState neighbor;
                if (!this.faces.test(context, direction) || !BlockPredicateHelper.fastMatch(this.block, neighbor = context.getLevel().getBlockState((BlockPos)mutable.setWithOffset((Vec3i)pos, direction)))) continue;
                for (ParsedProtoTag tag : this.tags) {
                    ParsedProtoTag resolvedTag = tag.resolve(neighbor, Rotation.NONE);
                    if (!PlaceSlot.find(neighbor, direction.getOpposite()).stream().noneMatch(slot -> slot.hasTag(resolvedTag))) continue;
                    continue block8;
                }
                return true;
            }
            return false;
        }
    }

    public record Preparation(Map<ResourceLocation, PlaceChoices> choices, Map<KBlockTemplate, KHolder<PlaceChoices>> byTemplate, Map<ResourceLocation, KHolder<PlaceChoices>> byBlock) {
        public static Preparation of(Supplier<Map<ResourceLocation, PlaceChoices>> choicesSupplier, Map<ResourceLocation, KBlockTemplate> templates) {
            Map<ResourceLocation, PlaceChoices> choices = Platform.isDataGen() ? Map.of() : choicesSupplier.get();
            HashMap byTemplate = Maps.newHashMap();
            HashMap byBlock = Maps.newHashMap();
            for (Map.Entry entry : choices.entrySet()) {
                KHolder<PlaceChoices> holder = new KHolder<PlaceChoices>((ResourceLocation)entry.getKey(), (PlaceChoices)entry.getValue());
                for (PlaceTarget target : holder.value().target) {
                    switch (target.type()) {
                        case TEMPLATE: {
                            KBlockTemplate template = templates.get(target.id());
                            if (template == null) {
                                Kiwi.LOGGER.error("Template {} not found for place choices {}", (Object)target.id(), holder);
                                break;
                            }
                            KHolder<PlaceChoices> oldChoices = byTemplate.put(template, holder);
                            if (oldChoices == null) break;
                            Kiwi.LOGGER.error("Duplicate place choices for template {}: {} and {}", new Object[]{template, oldChoices, holder});
                            break;
                        }
                        case BLOCK: {
                            KHolder<PlaceChoices> oldChoices = byBlock.put(target.id(), holder);
                            if (oldChoices == null) break;
                            Kiwi.LOGGER.error("Duplicate place choices for block {}: {} and {}", new Object[]{target.id(), oldChoices, holder});
                        }
                    }
                }
            }
            return new Preparation(choices, byTemplate, byBlock);
        }

        public boolean attachChoicesA(Block block, KBlockDefinition definition) {
            KHolder<PlaceChoices> choices = this.byTemplate.get(definition.template().template());
            PlaceChoices.setTo(block, choices);
            return choices != null;
        }

        public int attachChoicesB() {
            AtomicInteger counter = new AtomicInteger();
            this.byBlock.forEach((blockId, choices) -> {
                Block block = (Block)BuiltInRegistries.BLOCK.get(blockId);
                if (block == Blocks.AIR) {
                    Kiwi.LOGGER.error("Block %s not found for place choices %s".formatted(blockId, choices));
                    return;
                }
                PlaceChoices.setTo(block, choices);
                counter.incrementAndGet();
            });
            return counter.get();
        }
    }
}

