/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;

public record MouldingComponent(Optional<TagKey<Block>> connectTo) implements KBlockComponent
{
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.STAIRS_SHAPE;
    private static final MouldingComponent DEFAULT = new MouldingComponent(Optional.empty());
    public static final MapCodec<MouldingComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.hashedCodec((ResourceKey)Registries.BLOCK).optionalFieldOf("connect_to").forGetter(MouldingComponent::connectTo)).apply((Applicative)instance, MouldingComponent::create));

    public static MouldingComponent create(Optional<TagKey<Block>> connectTo) {
        return connectTo.isEmpty() ? DEFAULT : new MouldingComponent(connectTo);
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.MOULDING.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, SHAPE});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(SHAPE, (Comparable)StairsShape.STRAIGHT);
    }

    @Override
    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    private StairsShape getShapeAt(BlockState ourState, BlockGetter pLevel, BlockPos pPos) {
        Direction theirFacing;
        Direction ourFacing = (Direction)ourState.getValue((Property)FACING);
        BlockState theirState = pLevel.getBlockState(pPos.relative(ourFacing));
        if (this.canBeConnected(ourState, theirState) && (theirFacing = (Direction)theirState.getValue((Property)FACING)).getAxis() != ourFacing.getAxis() && this.canTakeShape(ourState, pLevel, pPos, theirFacing.getOpposite())) {
            if (theirFacing == ourFacing.getCounterClockWise()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        theirState = pLevel.getBlockState(pPos.relative(ourFacing.getOpposite()));
        if (this.canBeConnected(ourState, theirState) && (theirFacing = (Direction)theirState.getValue((Property)FACING)).getAxis() != ourFacing.getAxis() && this.canTakeShape(ourState, pLevel, pPos, theirFacing)) {
            if (theirFacing == ourFacing.getCounterClockWise()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private boolean canTakeShape(BlockState ourState, BlockGetter pLevel, BlockPos pPos, Direction pFace) {
        BlockState blockState = pLevel.getBlockState(pPos.relative(pFace));
        return !this.canBeConnected(ourState, blockState) || blockState.getValue((Property)FACING) != ourState.getValue((Property)FACING);
    }

    private boolean canBeConnected(BlockState ourState, BlockState theirState) {
        return this.connectTo.isEmpty() ? ourState.is(theirState.getBlock()) : theirState.is(this.connectTo.get());
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(KBlockSettings settings, BlockState state, BlockPlaceContext context) {
        if (settings.customPlacement) {
            return state;
        }
        BlockPos blockpos = context.getClickedPos();
        BlockState blockstate = (BlockState)state.setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
        if ((blockstate = (BlockState)blockstate.setValue(SHAPE, (Comparable)this.getShapeAt(blockstate, (BlockGetter)context.getLevel(), blockpos))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
            return blockstate;
        }
        return null;
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (pDirection.getAxis().isHorizontal()) {
            pState = (BlockState)pState.setValue(SHAPE, (Comparable)this.getShapeAt(pState, (BlockGetter)pLevel, pPos));
        }
        return pState;
    }

    @Override
    @Nullable
    public Direction getHorizontalFacing(BlockState blockState) {
        if (blockState.getValue(SHAPE) == StairsShape.STRAIGHT) {
            return ((Direction)blockState.getValue((Property)FACING)).getOpposite();
        }
        return null;
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        StairsShape stairsshape = (StairsShape)pState.getValue(SHAPE);
        switch (pMirror) {
            case LEFT_RIGHT: {
                if (direction.getAxis() != Direction.Axis.Z) break;
                return switch (stairsshape) {
                    default -> throw new MatchException(null, null);
                    case StairsShape.INNER_LEFT -> (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.INNER_RIGHT -> (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.OUTER_LEFT -> (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> pState.rotate(Rotation.CLOCKWISE_180);
                };
            }
            case FRONT_BACK: {
                if (direction.getAxis() != Direction.Axis.X) break;
                return switch (stairsshape) {
                    default -> throw new MatchException(null, null);
                    case StairsShape.INNER_LEFT -> (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    case StairsShape.INNER_RIGHT -> (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    case StairsShape.OUTER_LEFT -> (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    case StairsShape.OUTER_RIGHT -> (BlockState)pState.rotate(Rotation.CLOCKWISE_180).setValue(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    case StairsShape.STRAIGHT -> pState.rotate(Rotation.CLOCKWISE_180);
                };
            }
        }
        return pState;
    }
}

