/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;

public record FrontAndTopComponent() implements KBlockComponent
{
    public static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;
    private static final FrontAndTopComponent INSTANCE = new FrontAndTopComponent();

    public static FrontAndTopComponent getInstance() {
        return INSTANCE;
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.FRONT_AND_TOP.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ORIENTATION});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.setValue(ORIENTATION, (Comparable)FrontAndTop.NORTH_UP);
    }

    @Override
    public BlockState getStateForPlacement(KBlockSettings settings, BlockState state, BlockPlaceContext context) {
        if (settings.customPlacement) {
            return state;
        }
        Direction front = context.getClickedFace();
        Direction top = front.getAxis() == Direction.Axis.Y ? context.getHorizontalDirection() : Direction.UP;
        return (BlockState)state.setValue(ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)front, (Direction)top));
    }

    @Override
    public Direction getHorizontalFacing(BlockState blockState) {
        FrontAndTop frontAndTop = (FrontAndTop)blockState.getValue(ORIENTATION);
        if (frontAndTop.front().getAxis().isHorizontal()) {
            return frontAndTop.front();
        }
        return frontAndTop.top();
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue(ORIENTATION, (Comparable)pRotation.rotation().rotate((FrontAndTop)pState.getValue(ORIENTATION)));
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return (BlockState)pState.setValue(ORIENTATION, (Comparable)pMirror.rotation().rotate((FrontAndTop)pState.getValue(ORIENTATION)));
    }
}

