/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.contributor.ITierProvider;
import snownee.kiwi.contributor.client.CosmeticLayer;

public class JsonTierProvider
implements ITierProvider {
    public static final Gson GSON = new GsonBuilder().setLenient().create();
    public static final Codec<Map<String, List<String>>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf());
    private final String author;
    private ImmutableSetMultimap<String, String> contributors = ImmutableSetMultimap.of();
    protected ImmutableSet<String> superusers = ImmutableSet.of();
    private final Supplier<List<String>> urlProvider;

    public JsonTierProvider(String author, Supplier<List<String>> urlProvider) {
        this.author = author;
        this.urlProvider = urlProvider;
        this.refresh();
    }

    public boolean load(String url) {
        boolean bl;
        InputStreamReader reader = new InputStreamReader(URI.create(url).toURL().openStream());
        try {
            JsonElement json = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            Map map = (Map)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElseThrow();
            ImmutableSet.Builder superusers = ImmutableSet.builder();
            if (map.containsKey("*")) {
                superusers.addAll((Iterable)map.get("*"));
                superusers.add((Object)"Dev");
            } else {
                superusers.add((Object)this.getAuthor());
            }
            ImmutableSetMultimap.Builder contributors = ImmutableSetMultimap.builder();
            map.forEach((reward, users) -> {
                if ("*".equals(reward)) {
                    return;
                }
                users.forEach(user -> contributors.put(user, reward));
            });
            this.contributors = contributors.build();
            this.superusers = superusers.build();
            Kiwi.LOGGER.debug("Successfully loaded {} contributors", (Object)this.contributors.keySet().size());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Kiwi.LOGGER.debug("Failed to load contributors from %s".formatted(url), (Throwable)e);
                return e instanceof UnknownHostException;
            }
        }
        reader.close();
        return bl;
    }

    @Override
    public CompletableFuture<Void> refresh() {
        return CompletableFuture.runAsync(() -> {
            List<String> url = this.urlProvider.get();
            for (int tried = 0; tried < url.size() && !this.load(url.get(tried)); ++tried) {
            }
        });
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public Set<String> getPlayerTiers(String playerName) {
        return this.superusers.contains((Object)playerName) ? this.getTiers() : this.contributors.get((Object)playerName);
    }

    @Override
    public Set<String> getTiers() {
        return this.contributors.keySet();
    }

    @Override
    public List<String> getRenderableTiers() {
        return List.of();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public CosmeticLayer createRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> entityRenderer, String tier) {
        return null;
    }
}

