/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.VoxelUtil;

public record SixWayShape(VoxelShape[] shapes, VoxelShape base, VoxelShape trueDown, VoxelShape falseDown) implements ShapeGenerator
{
    private static final List<BooleanProperty> DIRECTION_PROPERTIES = List.of(BlockStateProperties.DOWN, BlockStateProperties.UP, BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.EAST);

    public static ShapeGenerator create(ShapeGenerator base_, ShapeGenerator trueDown_, ShapeGenerator falseDown_) {
        VoxelShape base = ShapeGenerator.Unit.unboxOrThrow(base_);
        VoxelShape trueDown = ShapeGenerator.Unit.unboxOrThrow(trueDown_);
        VoxelShape falseDown = ShapeGenerator.Unit.unboxOrThrow(falseDown_);
        Preconditions.checkArgument((!trueDown.isEmpty() || !falseDown.isEmpty() ? 1 : 0) != 0);
        VoxelShape[] shapes = new VoxelShape[64];
        return new SixWayShape(shapes, base, trueDown, falseDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public VoxelShape getShape(BlockState blockState, CollisionContext context) {
        int index = 0;
        for (int i = 0; i < 6; ++i) {
            if (!((Boolean)blockState.getValue((Property)DIRECTION_PROPERTIES.get(i))).booleanValue()) continue;
            index |= 1 << i;
        }
        VoxelShape shape = this.shapes[index];
        if (shape != null) return shape;
        VoxelShape[] voxelShapeArray = this.shapes;
        synchronized (this.shapes) {
            shape = this.shapes[index];
            if (shape != null) return shape;
            shape = this.base;
            for (int i = 0; i < 6; ++i) {
                VoxelShape sideShape = VoxelUtil.rotate((index & 1 << i) != 0 ? this.trueDown : this.falseDown, Direction.from3DDataValue((int)i));
                shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)sideShape, (BooleanOp)BooleanOp.OR);
            }
            this.shapes[index] = shape = shape.optimize();
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return shape;
        }
    }

    public record Unbaked(UnbakedShape base, UnbakedShape trueDown, UnbakedShape falseDown) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)parentCodec.fieldOf("base").forGetter(Unbaked::base), (App)parentCodec.fieldOf("true_down").forGetter(Unbaked::trueDown), (App)parentCodec.fieldOf("false_down").forGetter(Unbaked::falseDown)).apply((Applicative)instance, Unbaked::new));
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return SixWayShape.create(this.base.bake(context), this.trueDown.bake(context), this.falseDown.bake(context));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return Stream.of(this.base, this.trueDown, this.falseDown);
        }
    }
}

