/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easymagic.world.inventory;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import fuzs.easymagic.EasyMagic;
import fuzs.easymagic.config.ServerConfig;
import fuzs.easymagic.init.ModRegistry;
import fuzs.easymagic.network.ClientboundEnchantmentCluesMessage;
import fuzs.easymagic.util.ChiseledBookshelfHelper;
import fuzs.easymagic.util.PlayerExperienceHelper;
import fuzs.easymagic.world.inventory.QuickMoveRuleSet;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantingTableBlock;

public class ModEnchantmentMenu
extends EnchantmentMenu
implements ContainerListener {
    static final ResourceLocation EMPTY_SLOT_LAPIS_LAZULI = ResourceLocationHelper.withDefaultNamespace((String)"item/empty_slot_lapis_lazuli");
    static final ResourceLocation EMPTY_SLOT_AMETHYST_SHARD = ResourceLocation.withDefaultNamespace((String)"item/empty_slot_amethyst_shard");
    static final int REROLL_CATALYST_SLOT = 38;
    public static final int REROLL_DATA_SLOT = 4;
    public final Player player;
    public final List<List<EnchantmentInstance>> clues = Arrays.asList(List.of(), List.of(), List.of());

    public ModEnchantmentMenu(int id, Inventory inventory) {
        this(id, inventory, (Container)new SimpleContainer(3), ContainerLevelAccess.NULL);
    }

    public ModEnchantmentMenu(int id, Inventory inventory, Container container, ContainerLevelAccess access) {
        super(id, inventory, access);
        this.enchantSlots = container;
        this.player = inventory.player;
        Slot slot = this.addSlot(new Slot(this, container, 2, 41, 47){

            public boolean mayPlace(ItemStack itemStack) {
                return itemStack.is(ModRegistry.REROLL_CATALYSTS_ITEM_TAG);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_SLOT_AMETHYST_SHARD);
            }

            public boolean isActive() {
                return ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst();
            }
        });
        this.setSlot(0, new Slot(this, container, 0, slot.isActive() ? 5 : 15, 47){

            public int getMaxStackSize() {
                return 1;
            }
        });
        this.setSlot(1, new Slot(this, container, 1, slot.isActive() ? 23 : 35, 47){

            public boolean mayPlace(ItemStack itemStack) {
                return itemStack.is(ModRegistry.ENCHANTING_CATALYSTS_ITEM_TAG);
            }

            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)EMPTY_SLOT_LAPIS_LAZULI);
            }
        });
        this.addSlotListener(this);
    }

    public Slot setSlot(int index, Slot slot) {
        slot.index = index;
        this.slots.set(index, (Object)slot);
        return slot;
    }

    public MenuType<?> getType() {
        return (MenuType)ModRegistry.ENCHANTING_MENU_TYPE.value();
    }

    public void slotsChanged(Container container) {
        if (container == this.enchantSlots) {
            ItemStack itemStack = container.getItem(0);
            if (!itemStack.isEmpty() && itemStack.isEnchantable()) {
                this.access.execute((level, pos) -> {
                    int enchantingPower = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower == 0 ? 15 : this.getEnchantingPower((Level)level, (BlockPos)pos) * 15 / ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).maxEnchantingPower;
                    this.random.setSeed((long)this.enchantmentSeed.get());
                    this.updateLevelsAndClues(level.registryAccess(), itemStack, enchantingPower);
                    this.broadcastChanges();
                });
            } else {
                this.resetLevelsAndClues();
            }
        }
    }

    private int getEnchantingPower(Level level, BlockPos blockPos) {
        float enchantingPower = 0.0f;
        int chiseledBookshelfBooks = 0;
        for (BlockPos offset : EnchantingTableBlock.BOOKSHELF_OFFSETS) {
            if (!EnchantingTableBlock.isValidBookShelf((Level)level, (BlockPos)blockPos, (BlockPos)offset)) continue;
            enchantingPower += CommonAbstractions.INSTANCE.getEnchantPowerBonus(level.getBlockState(blockPos.offset((Vec3i)offset)), level, blockPos.offset((Vec3i)offset));
            chiseledBookshelfBooks += ChiseledBookshelfHelper.findValidBooks(level, blockPos, offset);
        }
        return (int)enchantingPower + chiseledBookshelfBooks / 3;
    }

    private void resetLevelsAndClues() {
        for (int i = 0; i < 3; ++i) {
            this.costs[i] = 0;
            this.enchantClue[i] = -1;
            this.levelClue[i] = -1;
        }
    }

    private void updateLevelsAndClues(RegistryAccess registries, ItemStack itemStack, int enchantingPower) {
        for (int i = 0; i < 3; ++i) {
            List enchantmentList;
            this.costs[i] = EnchantmentHelper.getEnchantmentCost((RandomSource)this.random, (int)i, (int)enchantingPower, (ItemStack)itemStack);
            if (this.costs[i] < i + 1) {
                this.costs[i] = 0;
            }
            if ((enchantmentList = this.getEnchantmentList(registries, itemStack, i, this.costs[i])).isEmpty()) {
                this.costs[i] = 0;
            }
            this.clues.set(i, this.createClue(enchantmentList));
        }
    }

    private List<EnchantmentInstance> createClue(List<EnchantmentInstance> enchantmentList) {
        return switch (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).enchantmentHint) {
            default -> throw new MatchException(null, null);
            case ServerConfig.EnchantmentHint.NONE -> Collections.emptyList();
            case ServerConfig.EnchantmentHint.SINGLE -> {
                if (enchantmentList.isEmpty()) {
                    yield Collections.emptyList();
                }
                yield Collections.singletonList(enchantmentList.get(this.random.nextInt(enchantmentList.size())));
            }
            case ServerConfig.EnchantmentHint.ALL -> ImmutableList.copyOf(enchantmentList);
        };
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        EasyMagic.NETWORK.sendMessage(PlayerSet.ofEntity((Entity)this.player), (ClientboundMessage)new ClientboundEnchantmentCluesMessage(this.containerId, this.clues));
    }

    public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
        if (abstractContainerMenu == this) {
            this.access.execute((Level2, BlockPos2) -> {
                if (i >= 0 && i < 2) {
                    this.slotsChanged(this.enchantSlots);
                }
            });
        }
    }

    public void dataChanged(AbstractContainerMenu abstractContainerMenu, int dataSlotIndex, int value) {
    }

    public boolean clickMenuButton(Player player, int data) {
        if (data == 4) {
            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollEnchantments && this.canEnchantItem() && this.canUseReroll(player)) {
                this.access.execute((level, pos) -> {
                    this.enchantmentSeed.set(player.getRandom().nextInt());
                    player.enchantmentSeed = this.enchantmentSeed.get();
                    if (!player.getAbilities().instabuild) {
                        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost > 0) {
                            int catalystSlot = this.getRerollCatalystSlot();
                            ItemStack itemStack = this.enchantSlots.getItem(catalystSlot);
                            itemStack.shrink(((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost);
                            if (itemStack.isEmpty()) {
                                this.enchantSlots.setItem(catalystSlot, ItemStack.EMPTY);
                            }
                        }
                        if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost > 0) {
                            if (((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollingTakesEnchantmentLevels) {
                                player.giveExperienceLevels(-((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost);
                            } else {
                                player.giveExperiencePoints(-((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost);
                            }
                        }
                    }
                    this.enchantSlots.setChanged();
                    this.slotsChanged(this.enchantSlots);
                });
                return true;
            }
            return false;
        }
        return super.clickMenuButton(player, data);
    }

    public boolean canEnchantItem() {
        return this.enchantSlots.getItem(0).isEnchantable();
    }

    private int getRerollCatalystSlot() {
        return ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst ? 2 : 1;
    }

    public int getRerollCatalystCount() {
        return this.enchantSlots.getItem(this.getRerollCatalystSlot()).getCount();
    }

    public boolean canUseReroll(Player player) {
        if (player.getAbilities().instabuild) {
            return true;
        }
        int rerollExperiencePointsCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollExperiencePointsCost;
        int rerollCatalystCost = ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).rerollCatalystCost;
        return PlayerExperienceHelper.getTotalExperience(player) >= rerollExperiencePointsCost && this.getRerollCatalystCount() >= rerollCatalystCost;
    }

    public boolean stillValid(Player player) {
        return this.enchantSlots.stillValid(player);
    }

    public void removed(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemStack = this.getCarried();
            if (!itemStack.isEmpty()) {
                if (player.isAlive() && !serverPlayer.hasDisconnected()) {
                    player.getInventory().placeItemBackInInventory(itemStack);
                } else {
                    player.drop(itemStack, false);
                }
                this.setCarried(ItemStack.EMPTY);
            }
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return QuickMoveRuleSet.of((AbstractContainerMenu)this, (x$0, x$1, x$2, x$3) -> this.moveItemStackTo(x$0, x$1, x$2, x$3)).addContainerSlotRule(1).addContainerSlotRule(38, slot -> ((ServerConfig)EasyMagic.CONFIG.get(ServerConfig.class)).dedicatedRerollCatalyst()).addContainerSlotRule(0, slot -> this.isEnchantable(slot.getItem())).addInventoryRules().addInventoryCompartmentRules().quickMoveStack(player, index);
    }

    private boolean isEnchantable(ItemStack itemStack) {
        if (!((ItemEnchantments)itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty()) {
            return false;
        }
        return itemStack.getItem().isEnchantable(itemStack) || itemStack.getItem().getEnchantmentValue() > 0;
    }
}

