/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.mixin.chat;

import dev.arbor.extrasoundsnext.sounds.SoundManager;
import dev.arbor.extrasoundsnext.sounds.SoundType;
import dev.arbor.extrasoundsnext.sounds.Sounds;
import java.util.Objects;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChatComponent.class})
public abstract class ChatHudMixin {
    @Shadow
    private int chatScrollbarPos;
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private int extra_sounds$currentLines;

    @Inject(method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;Lnet/minecraft/client/GuiMessageTag;)V"}, at={@At(value="RETURN")})
    private void extrasounds$receiveMessage(Component component, @Nullable MessageSignature pHeaderSignature, @Nullable GuiMessageTag pTag, CallbackInfo ci) {
        LocalPlayer player = this.minecraft.player;
        if (player == null) {
            return;
        }
        String msg = component.getString();
        if (msg.contains("@" + player.getName().getString()) || msg.contains("@" + Objects.requireNonNull(player.getDisplayName()).getString())) {
            SoundManager.playSound(Sounds.CHAT_MENTION, SoundType.CHAT_MENTION);
        } else {
            SoundManager.playSound(Sounds.CHAT, SoundType.CHAT);
        }
    }

    @Inject(method={"scrollChat(I)V"}, at={@At(value="RETURN")})
    private void extrasounds$onScroll(int amount, CallbackInfo ci) {
        if (this.chatScrollbarPos != this.extra_sounds$currentLines) {
            SoundManager.playSound(Sounds.INVENTORY_SCROLL, SoundType.CHAT);
            this.extra_sounds$currentLines = this.chatScrollbarPos;
        }
    }
}

