/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.mapping;

import dev.arbor.extrasoundsnext.ExtraSoundsNext;
import dev.arbor.extrasoundsnext.debug.DebugUtils;
import dev.arbor.extrasoundsnext.mapping.SoundDefinition;
import dev.arbor.extrasoundsnext.mixin.misc.BucketFluidAccessor;
import dev.arbor.extrasoundsnext.sounds.Categories;
import dev.arbor.extrasoundsnext.sounds.Sounds;
import java.util.function.Function;
import net.minecraft.client.resources.sounds.SoundEventRegistration;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

public final class SoundGenerator {
    public final String namespace;
    public final Function<Item, SoundDefinition> itemSoundGenerator;

    private SoundGenerator(String namespace, Function<Item, SoundDefinition> itemSoundGenerator) {
        this.namespace = namespace;
        this.itemSoundGenerator = itemSoundGenerator;
    }

    public static SoundGenerator of(@NotNull String namespace, @NotNull Function<Item, SoundDefinition> itemSoundGenerator) {
        return new SoundGenerator(namespace, itemSoundGenerator);
    }

    public static String getDescriptionId(Item item) {
        String id = "";
        try {
            id = item.getDescriptionId();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return id;
    }

    public static SoundDefinition getBucketItemSound(BucketItem bucketItem) {
        SoundEventRegistration soundEntry;
        try {
            Fluid fluid = ((BucketFluidAccessor)bucketItem).getContent();
            soundEntry = fluid.getPickupSound().map(sound -> Sounds.event(sound.getLocation(), 0.4f)).orElse(Sounds.aliased(Categories.METAL));
        }
        catch (NullPointerException ignored) {
            soundEntry = Sounds.aliased(Categories.METAL);
        }
        return SoundDefinition.of(soundEntry);
    }

    public static SoundType getSoundType(Block block) {
        try {
            return block.defaultBlockState().getSoundType();
        }
        catch (Throwable e) {
            if (DebugUtils.DEBUG) {
                ExtraSoundsNext.LOGGER.error("Failed to get sound type for block {}", (Object)block, (Object)e);
            }
            return SoundType.STONE;
        }
    }
}

