/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.debug;

import dev.arbor.extrasoundsnext.ExtraSoundsNext;
import dev.arbor.extrasoundsnext.mapping.SoundGenerator;
import dev.arbor.extrasoundsnext.sounds.SoundManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.world.effect.MobEffect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DebugUtils {
    public static final String DEBUG_VAR = "extrasounds.debug";
    public static final String DEBUG_PATH_VAR = "extrasounds.debug.path";
    public static final String NO_CACHE_VAR = "extrasounds.nocache";
    private static final String JVM_ARG_SEARCH_UNDEF_SND = "extrasounds.searchundef";
    public static final boolean DEBUG = System.getProperties().containsKey("extrasounds.debug") && System.getProperties().get("extrasounds.debug").equals("true");
    public static final String DEBUG_PATH = System.getProperties().containsKey("extrasounds.debug.path") ? System.getProperty("extrasounds.debug.path") : "debug/";
    public static final boolean NO_CACHE = System.getProperties().containsKey("extrasounds.nocache") && System.getProperties().get("extrasounds.nocache").equals("true");
    public static final boolean SEARCH_UNDEF_SOUND = System.getProperties().containsKey("extrasounds.searchundef") && System.getProperties().get("extrasounds.searchundef").equals("true");
    private static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        if (!DEBUG) {
            return;
        }
        LOGGER.info("ExtraSounds: DEBUG mode enabled.");
        LOGGER.info("Debug path: " + String.valueOf(Path.of(DEBUG_PATH, new String[0]).toAbsolutePath()));
        if (NO_CACHE) {
            LOGGER.info("ExtraSounds: No cache mode enabled.");
        }
        if (SEARCH_UNDEF_SOUND) {
            LOGGER.info("ExtraSounds: Searching for undefined sounds.");
        }
    }

    public static void exportSoundsJson(byte[] jsonData) {
        if (!DEBUG) {
            return;
        }
        Path p = null;
        try {
            p = Path.of(DEBUG_PATH, new String[0]).resolve("sounds.json");
            DebugUtils.createFile(p);
            Files.write(p, jsonData, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            ExtraSoundsNext.LOGGER.error("Failed to write to file: {}", (Object)p.toAbsolutePath(), (Object)e);
        }
    }

    public static void exportGenerators(Map<String, SoundGenerator> generator) {
        if (!DEBUG) {
            return;
        }
        Path p = Path.of(DEBUG_PATH, new String[0]).resolve("generators.txt");
        DebugUtils.createFile(p);
        try {
            Files.write(p, (Iterable<? extends CharSequence>)generator.keySet().stream().map(it -> {
                Class<?> clazz = ((SoundGenerator)generator.get((Object)it)).itemSoundGenerator.getClass();
                return "namespace: " + it + "; class: " + clazz.getName();
            }).collect(Collectors.toList()), new OpenOption[0]);
        }
        catch (IOException e) {
            ExtraSoundsNext.LOGGER.error("Failed to write to file: {}", (Object)p.toAbsolutePath(), (Object)e);
        }
    }

    public static void soundLog(SoundInstance instance) {
        if (!DEBUG) {
            return;
        }
        LOGGER.info("Playing sound: {}", (Object)instance.getLocation());
    }

    public static void effectLog(MobEffect effect, SoundManager.EffectType type) {
        if (!DEBUG) {
            return;
        }
        LOGGER.info("EffectType = {}, Effect = {}", (Object)type, (Object)effect.getDisplayName().getString());
    }

    public static void genericLog(String message) {
        if (!DEBUG) {
            return;
        }
        LOGGER.info(message);
    }

    private static void createFile(Path p) {
        try {
            Path debugPath = Path.of(DEBUG_PATH, new String[0]);
            if (!Files.isDirectory(debugPath, new LinkOption[0])) {
                Files.createDirectory(debugPath, new FileAttribute[0]);
            }
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createFile(p, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            ExtraSoundsNext.LOGGER.error("Failed to create file: {}", (Object)p.toAbsolutePath(), (Object)e);
        }
    }
}

