/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion;

import com.google.gson.annotations.SerializedName;
import com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion.LiquidRegions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;

public class LiquidRegionsController {
    public static LiquidRegionsController INSTANCE;
    private final transient ConcurrentMap<ServerLevel, LiquidRegions> regionsByLevel = new ConcurrentHashMap<ServerLevel, LiquidRegions>();
    @SerializedName(value="liquidRegions")
    private final Map<ResourceLocation, LiquidRegions.Settings> settingsByDimensionId = new ConcurrentHashMap<ResourceLocation, LiquidRegions.Settings>();

    public static LiquidRegionsController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LiquidRegionsController();
        }
        return INSTANCE;
    }

    public static void useDefaultSettings() {
        LiquidRegionsController controller = new LiquidRegionsController();
        controller.settingsByDimensionId.put(ResourceLocation.withDefaultNamespace((String)"overworld"), LiquidRegions.Settings.DEFAULT.copy());
        INSTANCE = controller;
    }

    public boolean hasSettingsForLevel(ServerLevel serverLevel) {
        ResourceLocation dimensionId = serverLevel.dimension().location();
        return this.settingsByDimensionId.containsKey(dimensionId);
    }

    public LiquidRegions getLiquidRegionsForServerLevel(ServerLevel serverLevel) {
        return this.regionsByLevel.computeIfAbsent(serverLevel, sl -> {
            LiquidRegions.Settings settings = this.settingsByDimensionId.get(sl.dimension().location());
            if (settings == null) {
                throw new IllegalStateException("No LiquidRegions settings found for dimension: " + String.valueOf(sl.dimension().location()));
            }
            return new LiquidRegions((ServerLevel)sl, settings);
        });
    }
}

