/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.worldgen.liquidregion;

import com.google.gson.annotations.SerializedName;
import com.yungnickyoung.minecraft.bettercaves.BetterCavesCommon;
import com.yungnickyoung.minecraft.bettercaves.noise.NoiseUtils;
import com.yungnickyoung.minecraft.yungsapi.math.ColPos;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LiquidRegions {
    public static final double DEFAULT_SIZE = 0.001;
    public static final double DEFAULT_SPAWN_CHANCE = 40.0;
    public static final int DEFAULT_ALTITUDE = -55;
    private final Settings settings;
    private final ServerLevel serverLevel;
    private final Random rand;
    private final FastNoise liquidRegionSampler;
    private final float liquidRegionThreshold;
    public final ConcurrentHashMap<ChunkPos, CacheData> cache = new ConcurrentHashMap();
    private static final float SMOOTH_RANGE = 0.05f;
    private static final float SMOOTH_DELTA = 0.005f;

    public LiquidRegions(ServerLevel serverLevel, Settings settings) {
        this.settings = settings;
        this.serverLevel = serverLevel;
        this.rand = new Random();
        this.liquidRegionThreshold = NoiseUtils.simplexNoiseOffsetByPercent(-1.0f, (float)(settings.waterRegionSpawnChance() / 100.0));
        double liquidRegionSize = settings.liquidRegionSize();
        this.liquidRegionSampler = new FastNoise();
        this.liquidRegionSampler.SetSeed((int)this.serverLevel.getSeed() + 444);
        this.liquidRegionSampler.SetFrequency((float)liquidRegionSize);
    }

    public CacheData getOrCreateLiquidBlocksForChunk(ChunkPos chunkPos) {
        if (this.cache.containsKey(chunkPos)) {
            return this.cache.get(chunkPos);
        }
        this.rand.setSeed(this.serverLevel.getSeed() ^ (long)chunkPos.x ^ (long)chunkPos.z);
        BlockState[][] blocks = new BlockState[16][16];
        ColPos.Mutable pos = new ColPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                pos.set(chunkPos.x * 16 + x, chunkPos.z * 16 + z);
                blocks[x][z] = this.getLiquidBlockAtPos(this.rand, (ColPos)pos);
            }
        }
        CacheData cacheData = new CacheData(blocks, this.getLiquidAltitude());
        this.cache.put(chunkPos, cacheData);
        return cacheData;
    }

    public int getLiquidAltitude() {
        return this.settings.liquidAltitude();
    }

    private BlockState getLiquidBlockAtPos(Random rand, ColPos colPos) {
        float barrierZoneWidth;
        if (this.liquidRegionThreshold <= -1.0f) {
            return Blocks.LAVA.defaultBlockState();
        }
        float liquidRegionNoise = this.liquidRegionSampler.GetNoise((float)colPos.getX(), (float)colPos.getZ());
        if (liquidRegionNoise < this.liquidRegionThreshold - (barrierZoneWidth = rand.nextFloat() * 0.005f + 0.05f)) {
            return Blocks.WATER.defaultBlockState();
        }
        if (liquidRegionNoise < this.liquidRegionThreshold + barrierZoneWidth) {
            return null;
        }
        return Blocks.LAVA.defaultBlockState();
    }

    public record Settings(@SerializedName(value="liquid_region_size") double liquidRegionSize, @SerializedName(value="water_region_spawn_chance") double waterRegionSpawnChance, @SerializedName(value="liquid_altitude") int liquidAltitude) {
        public static final Settings DEFAULT = new Settings(0.001, 40.0, -55);

        public Settings {
            if (liquidRegionSize <= 0.0) {
                BetterCavesCommon.LOGGER.error("liquid_region_size must be greater than 0.");
                BetterCavesCommon.LOGGER.error("Double check that your liquidregions.json config is correct.");
                BetterCavesCommon.LOGGER.error("Using default value of {}...", (Object)0.001);
                liquidRegionSize = 0.001;
            }
            if (waterRegionSpawnChance < 0.0 || waterRegionSpawnChance > 100.0) {
                BetterCavesCommon.LOGGER.error("water_region_spawn_chance must be between 0 and 100.");
                BetterCavesCommon.LOGGER.error("Double check that your liquidregions.json config is correct.");
                BetterCavesCommon.LOGGER.error("Using default value of {}...", (Object)40.0);
                waterRegionSpawnChance = 40.0;
            }
        }

        public Settings copy() {
            return new Settings(this.liquidRegionSize, this.waterRegionSpawnChance, this.liquidAltitude);
        }
    }

    public record CacheData(BlockState[][] liquidBlocks, int liquidAltitude) {
    }
}

