/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.utility;

import com.simibubi.create.foundation.item.TagDependentIngredientItem;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;

public class MechanicalRegistrateDisplayItemsGenerator
implements CreativeModeTab.DisplayItemsGenerator {
    private final boolean addItems;
    private Collection<RegistryEntry<Item, Item>> items = List.of();
    private Collection<RegistryEntry<Block, Block>> blocks = List.of();
    private Map<ItemProviderEntry<?, ?>, Function<Item, ItemStack>> simpleFactories = Map.of();
    private Map<ItemProviderEntry<?, ?>, CreativeModeTab.TabVisibility> simpleVisibilities = Map.of();
    private Map<ItemProviderEntry<?, ?>, ItemProviderEntry<?, ?>> simpleBeforeOrderings = Map.of();
    private Map<ItemProviderEntry<?, ?>, ItemProviderEntry<?, ?>> simpleAfterOrderings = Map.of();
    private List<ItemProviderEntry<?, ?>> simpleExclusions = List.of();
    private List<ItemEntry<TagDependentIngredientItem>> tagDependentExclusion = List.of();
    private Consumer<List<ItemOrdering>> orderingsPost;
    private Consumer<Map<Item, CreativeModeTab.TabVisibility>> visibilitiesPost;
    private static final Predicate<Item> IS_ITEM_3D_PREDICATE;

    protected MechanicalRegistrateDisplayItemsGenerator(boolean addItems) {
        this.addItems = addItems;
    }

    public static MechanicalRegistrateDisplayItemsGenerator create(boolean addItems) {
        return new MechanicalRegistrateDisplayItemsGenerator(addItems);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Predicate<Item> makeClient3dItemPredicate() {
        return item -> {
            ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
            BakedModel model = itemRenderer.getModel(new ItemStack((ItemLike)item), null, null, 0);
            return model.isGui3d();
        };
    }

    public void accept(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        Predicate<Item> exclusionPredicate = this.makeExclusionPredicate();
        List<ItemOrdering> orderings = this.makeOrderings();
        Function<Item, ItemStack> stackFunc = this.makeStackFunc();
        Function<Item, CreativeModeTab.TabVisibility> visibilityFunc = this.makeVisibilityFunc();
        LinkedList<Item> items = new LinkedList<Item>();
        if (this.addItems) {
            items.addAll(this.collectItems(exclusionPredicate.or(IS_ITEM_3D_PREDICATE.negate())));
        }
        items.addAll(this.collectBlocks(exclusionPredicate));
        if (this.addItems) {
            items.addAll(this.collectItems(exclusionPredicate.or(IS_ITEM_3D_PREDICATE)));
        }
        this.applyOrderings(items, orderings);
        this.outputAll(output, items, stackFunc, visibilityFunc);
    }

    private List<ItemOrdering> makeOrderings() {
        ReferenceArrayList orderings = new ReferenceArrayList();
        this.simpleBeforeOrderings.forEach((arg_0, arg_1) -> MechanicalRegistrateDisplayItemsGenerator.lambda$makeOrderings$2((List)orderings, arg_0, arg_1));
        this.simpleAfterOrderings.forEach((arg_0, arg_1) -> MechanicalRegistrateDisplayItemsGenerator.lambda$makeOrderings$3((List)orderings, arg_0, arg_1));
        if (this.orderingsPost != null) {
            this.orderingsPost.accept((List<ItemOrdering>)orderings);
        }
        return orderings;
    }

    private Function<Item, ItemStack> makeStackFunc() {
        Reference2ReferenceOpenHashMap factories = new Reference2ReferenceOpenHashMap();
        this.simpleFactories.forEach((arg_0, arg_1) -> MechanicalRegistrateDisplayItemsGenerator.lambda$makeStackFunc$4((Map)factories, arg_0, arg_1));
        return arg_0 -> MechanicalRegistrateDisplayItemsGenerator.lambda$makeStackFunc$5((Map)factories, arg_0);
    }

    private Function<Item, CreativeModeTab.TabVisibility> makeVisibilityFunc() {
        Reference2ObjectOpenHashMap visibilities = new Reference2ObjectOpenHashMap();
        this.simpleVisibilities.forEach((arg_0, arg_1) -> MechanicalRegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$6((Map)visibilities, arg_0, arg_1));
        if (this.visibilitiesPost != null) {
            this.visibilitiesPost.accept((Map<Item, CreativeModeTab.TabVisibility>)visibilities);
        }
        return arg_0 -> MechanicalRegistrateDisplayItemsGenerator.lambda$makeVisibilityFunc$7((Map)visibilities, arg_0);
    }

    private void applyOrderings(List<Item> items, List<ItemOrdering> orderings) {
        for (ItemOrdering ordering : orderings) {
            int anchorIndex = items.indexOf(ordering.anchor());
            if (anchorIndex == -1) continue;
            Item item = ordering.item();
            int itemIndex = items.indexOf(item);
            if (itemIndex != -1) {
                items.remove(itemIndex);
                if (itemIndex < anchorIndex) {
                    --anchorIndex;
                }
            }
            if (ordering.type() == ItemOrdering.Type.AFTER) {
                items.add(anchorIndex + 1, item);
                continue;
            }
            items.add(anchorIndex, item);
        }
    }

    private List<Item> collectItems(Predicate<Item> exclusionPredicate) {
        ReferenceArrayList items = new ReferenceArrayList();
        for (RegistryEntry<Item, Item> entry : this.items) {
            Item item = (Item)entry.get();
            if (item instanceof BlockItem || exclusionPredicate.test(item)) continue;
            items.add(item);
        }
        return items;
    }

    private List<Item> collectBlocks(Predicate<Item> exclusionPredicate) {
        ReferenceArrayList items = new ReferenceArrayList();
        for (RegistryEntry<Block, Block> entry : this.blocks) {
            Item item = ((Block)entry.get()).asItem();
            if (item == Items.AIR || exclusionPredicate.test(item)) continue;
            items.add(item);
        }
        items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
        return items;
    }

    private Predicate<Item> makeExclusionPredicate() {
        ReferenceOpenHashSet exclusions = new ReferenceOpenHashSet();
        for (ItemProviderEntry<?, ?> itemProviderEntry : this.simpleExclusions) {
            exclusions.add(itemProviderEntry.asItem());
        }
        for (ItemEntry itemEntry : this.tagDependentExclusion) {
            TagDependentIngredientItem item = (TagDependentIngredientItem)itemEntry.get();
            if (!item.shouldHide()) continue;
            exclusions.add(itemEntry.asItem());
        }
        return ((Set)exclusions)::contains;
    }

    private void outputAll(CreativeModeTab.Output output, List<Item> items, Function<Item, ItemStack> stackFunc, Function<Item, CreativeModeTab.TabVisibility> visibilityFunc) {
        for (Item item : items) {
            output.accept(stackFunc.apply(item), visibilityFunc.apply(item));
        }
    }

    public MechanicalRegistrateDisplayItemsGenerator withItems(Collection<RegistryEntry<Item, Item>> items) {
        this.items = items;
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withItems(Supplier<Collection<RegistryEntry<Item, Item>>> items) {
        this.items = items.get();
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withBlocks(Collection<RegistryEntry<Block, Block>> blocks) {
        this.blocks = blocks;
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withBlocks(Supplier<Collection<RegistryEntry<Block, Block>>> blocks) {
        this.blocks = blocks.get();
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withFactories(Map<ItemProviderEntry<?, ?>, Function<Item, ItemStack>> factories) {
        this.simpleFactories = factories;
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withFactories(Supplier<Map<ItemProviderEntry<?, ?>, Function<Item, ItemStack>>> factories) {
        this.simpleFactories = factories.get();
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withVisibilities(Map<ItemProviderEntry<?, ?>, CreativeModeTab.TabVisibility> visibilities) {
        this.simpleVisibilities = visibilities;
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withVisibilities(Supplier<Map<ItemProviderEntry<?, ?>, CreativeModeTab.TabVisibility>> visibilities) {
        this.simpleVisibilities = visibilities.get();
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withVisibilitiesPost(Consumer<Map<Item, CreativeModeTab.TabVisibility>> visibilities) {
        this.visibilitiesPost = visibilities;
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withBeforeOrderings(Map<ItemProviderEntry<?, ?>, ItemProviderEntry<?, ?>> orderings) {
        this.simpleBeforeOrderings = orderings;
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withAfterOrderings(Map<ItemProviderEntry<?, ?>, ItemProviderEntry<?, ?>> orderings) {
        this.simpleAfterOrderings = orderings;
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withExclusions(List<ItemProviderEntry<?, ?>> exclusions) {
        this.simpleExclusions = exclusions;
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withExclusions(Supplier<List<ItemProviderEntry<?, ?>>> exclusions) {
        this.simpleExclusions = exclusions.get();
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withTagDependentExclusions(List<ItemEntry<TagDependentIngredientItem>> tagDependentExclusions) {
        this.tagDependentExclusion = tagDependentExclusions;
        return this;
    }

    public MechanicalRegistrateDisplayItemsGenerator withTagDependentExclusions(Supplier<List<ItemEntry<TagDependentIngredientItem>>> tagDependentExclusions) {
        this.tagDependentExclusion = tagDependentExclusions.get();
        return this;
    }

    private static /* synthetic */ CreativeModeTab.TabVisibility lambda$makeVisibilityFunc$7(Map visibilities, Item item) {
        CreativeModeTab.TabVisibility visibility = (CreativeModeTab.TabVisibility)visibilities.get(item);
        if (visibility != null) {
            return visibility;
        }
        return CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS;
    }

    private static /* synthetic */ void lambda$makeVisibilityFunc$6(Map visibilities, ItemProviderEntry entry, CreativeModeTab.TabVisibility factory) {
        visibilities.put(entry.asItem(), factory);
    }

    private static /* synthetic */ ItemStack lambda$makeStackFunc$5(Map factories, Item item) {
        Function factory = (Function)factories.get(item);
        if (factory != null) {
            return (ItemStack)factory.apply(item);
        }
        return new ItemStack((ItemLike)item);
    }

    private static /* synthetic */ void lambda$makeStackFunc$4(Map factories, ItemProviderEntry entry, Function factory) {
        factories.put(entry.asItem(), factory);
    }

    private static /* synthetic */ void lambda$makeOrderings$3(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
        orderings.add(ItemOrdering.after(entry.asItem(), otherEntry.asItem()));
    }

    private static /* synthetic */ void lambda$makeOrderings$2(List orderings, ItemProviderEntry entry, ItemProviderEntry otherEntry) {
        orderings.add(ItemOrdering.before(entry.asItem(), otherEntry.asItem()));
    }

    static {
        MutableObject isItem3d = new MutableObject(item -> false);
        if (CatnipServices.PLATFORM.getEnv().isClient()) {
            isItem3d.setValue(MechanicalRegistrateDisplayItemsGenerator.makeClient3dItemPredicate());
        }
        IS_ITEM_3D_PREDICATE = (Predicate)isItem3d.getValue();
    }

    public record ItemOrdering(Item item, Item anchor, Type type) {
        public static ItemOrdering before(Item item, Item anchor) {
            return new ItemOrdering(item, anchor, Type.BEFORE);
        }

        public static ItemOrdering after(Item item, Item anchor) {
            return new ItemOrdering(item, anchor, Type.AFTER);
        }

        public static enum Type {
            BEFORE,
            AFTER;

        }
    }
}

