/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public enum MechanicalGUITextures implements ScreenElement
{
    JEI_SHORT_ARROW("jei/widgets", 20, 9),
    JEI_DOWN_RIGHT_ARROW("jei/widgets", 0, 9, 17, 12),
    PLAYER_INVENTORY("player_inventory", 176, 108),
    BUTTON("widgets", 18, 18),
    BUTTON_HOVER("widgets", 18, 0, 18, 18),
    BUTTON_DOWN("widgets", 36, 0, 18, 18),
    SLOT_EMPTY("widgets", 36, 0, 18, 18),
    RF_VERTIVAL_BAR("widgets", 0, 18, 11, 32),
    PROGRESS_ARROW_EMPTY("widgets", 0, 48, 32, 8),
    PROGRESS_ARROW_FULL("widgets", 0, 56, 32, 8);

    public static final int FONT_COLOR = 5726074;
    public final ResourceLocation location;
    public int width;
    public int height;
    public int startX;
    public int startY;

    private MechanicalGUITextures(String location, int width, int height) {
        this(location, 0, 0, width, height);
    }

    private MechanicalGUITextures(int startX, int startY) {
        this("icons", startX * 16, startY * 16, 16, 16);
    }

    private MechanicalGUITextures(String location, int startX, int startY, int width, int height) {
        this("mechanicals", location, startX, startY, width, height);
    }

    private MechanicalGUITextures(String namespace, String location, int startX, int startY, int width, int height) {
        this.location = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)("textures/gui/" + location + ".png"));
        this.width = width;
        this.height = height;
        this.startX = startX;
        this.startY = startY;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.location);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        graphics.blit(this.location, x, y, this.startX, this.startY, this.width, this.height);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y, Color c) {
        this.bind();
        UIRenderHelper.drawColoredTexture((GuiGraphics)graphics, (Color)c, (int)x, (int)y, (int)this.startX, (int)this.startY, (int)this.width, (int)this.height);
    }
}

