/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.util;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class InventoryHelper {
    public static ListTag saveAllItems(HolderLookup.Provider provider, ListTag list, SimpleContainer container) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack itemstack = container.getItem(i);
            if (itemstack.isEmpty()) continue;
            CompoundTag compound = new CompoundTag();
            compound.putByte("Slot", (byte)i);
            itemstack.save(provider, (Tag)compound);
            list.add((Object)compound);
        }
        return list;
    }

    public static void loadAllItems(HolderLookup.Provider provider, ListTag list, SimpleContainer container, Level level, Vec3 pos) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack;
            CompoundTag compound = list.getCompound(i);
            int slot = compound.getByte("Slot") & 0xFF;
            if (slot < container.getContainerSize()) {
                container.setItem(slot, ItemStack.parse((HolderLookup.Provider)provider, (Tag)compound).orElse(ItemStack.EMPTY));
                continue;
            }
            if (level.isClientSide() || (stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)compound).orElse(ItemStack.EMPTY)).isEmpty()) continue;
            ItemEntity entity = new ItemEntity(level, pos.x, pos.y, pos.z, container.addItem(stack));
            entity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entity);
        }
    }

    public static void mergeInventory(SimpleContainer source, SimpleContainer target, Level level, Vec3 pos) {
        for (int i = 0; i < source.getContainerSize(); ++i) {
            if (i < target.getContainerSize()) {
                target.setItem(i, source.getItem(i).copy());
                continue;
            }
            if (level.isClientSide()) continue;
            ItemStack stack = source.getItem(i).copy();
            ItemEntity entity = new ItemEntity(level, pos.x, pos.y, pos.z, target.addItem(stack));
            entity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entity);
        }
    }

    public static Stream<ItemStack> streamFor(Container container) {
        return IntStream.range(0, container.getContainerSize()).mapToObj(arg_0 -> ((Container)container).getItem(arg_0));
    }
}

