/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.mixin.client;

import com.mrcrayfish.framework.api.client.FrameworkClientAPI;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BlockStateModelLoader;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBakery.class})
public abstract class ModelBakeryMixin {
    @Unique
    private static final Predicate<ResourceLocation> BACKPACKED_MODEL_TEST = location -> location.getPath().startsWith("models/backpacked");

    @Shadow
    abstract UnbakedModel getModel(ResourceLocation var1);

    @Shadow
    abstract void registerModelAndLoadDependencies(ModelResourceLocation var1, UnbakedModel var2);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void backpacked$OnLoadModels(BlockColors colors, ProfilerFiller filler, Map<ResourceLocation, BlockModel> models, Map<ResourceLocation, List<BlockStateModelLoader.LoadedJson>> json, CallbackInfo ci) {
        models.forEach((key, value) -> {
            if (BACKPACKED_MODEL_TEST.test((ResourceLocation)key)) {
                String path = key.getPath().substring("models/".length(), key.getPath().length() - ".json".length());
                ModelResourceLocation location = FrameworkClientAPI.createModelResourceLocation((String)key.getNamespace(), (String)path);
                UnbakedModel model = this.getModel(location.id());
                this.registerModelAndLoadDependencies(location, model);
            }
        });
    }
}

