/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.biome.Biome;

public class ExploreBiomeChallenge
extends Challenge {
    public static final Codec<List<ResourceKey<Biome>>> BIOME_LIST_CODEC = Codec.either((Codec)ResourceKey.codec((ResourceKey)Registries.BIOME), (Codec)ResourceKey.codec((ResourceKey)Registries.BIOME).listOf()).xmap(either -> (List)either.map(List::of, Function.identity()), keys -> keys.size() == 1 ? Either.left((Object)((ResourceKey)keys.get(0))) : Either.right((Object)keys)).validate(keys -> keys.isEmpty() ? DataResult.error(() -> "Must specify at least one biome") : DataResult.success((Object)keys));
    public static final ChallengeSerializer<ExploreBiomeChallenge> SERIALIZER = new ChallengeSerializer(ResourceLocation.fromNamespaceAndPath((String)"backpacked", (String)"explore_biome"), RecordCodecBuilder.mapCodec(builder -> builder.group((App)ProgressFormatter.CODEC.fieldOf("formatter").orElse((Object)ProgressFormatter.EXPLORED_X_OF_X).forGetter(challenge -> challenge.formatter), (App)BIOME_LIST_CODEC.fieldOf("biome").forGetter(challenge -> challenge.biomes)).apply((Applicative)builder, ExploreBiomeChallenge::new)));
    private final ProgressFormatter formatter;
    private final List<ResourceKey<Biome>> biomes;

    public ExploreBiomeChallenge(ProgressFormatter formatter, List<ResourceKey<Biome>> biomes) {
        this.formatter = formatter;
        this.biomes = biomes;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ResourceLocation backpackId) {
        return new Tracker(this.formatter, this.biomes);
    }

    public static class Tracker
    implements IProgressTracker {
        private final ProgressFormatter formatter;
        private final ImmutableSet<ResourceKey<Biome>> biomes;
        private final Set<ResourceLocation> exploredBiomes = new HashSet<ResourceLocation>();

        private Tracker(ProgressFormatter formatter, List<ResourceKey<Biome>> biomes) {
            this.formatter = formatter;
            this.biomes = ImmutableSet.copyOf(biomes);
        }

        private void explore(ResourceKey<Biome> biome, ServerPlayer player) {
            if (this.biomes.contains(biome)) {
                this.exploredBiomes.add(biome.location());
                this.markForCompletionTest(player);
            }
        }

        @Override
        public boolean isComplete() {
            return this.exploredBiomes.size() >= this.biomes.size();
        }

        @Override
        public void read(CompoundTag tag) {
            this.exploredBiomes.clear();
            ListTag list = tag.getList("ExploredBiomes", 8);
            list.forEach(nbt -> {
                ResourceLocation id = ResourceLocation.tryParse((String)nbt.getAsString());
                if (id != null && this.biomes.stream().anyMatch(key -> key.location().equals((Object)id))) {
                    this.exploredBiomes.add(id);
                }
            });
        }

        @Override
        public void write(CompoundTag tag) {
            ListTag list = new ListTag();
            this.exploredBiomes.forEach(location -> list.add((Object)StringTag.valueOf((String)location.toString())));
            tag.put("ExploredBiomes", (Tag)list);
        }

        @Override
        public Component getDisplayComponent() {
            return this.formatter.formatter().apply(this.exploredBiomes.size(), this.biomes.size());
        }

        public static void registerEvent() {
            BackpackedEvents.EXPLORE_UPDATE.register((key, player) -> {
                if (player.level().isClientSide()) {
                    return;
                }
                UnlockManager.getTrackers(player, Tracker.class).forEach(tracker -> {
                    if (!tracker.isComplete()) {
                        tracker.explore((ResourceKey<Biome>)key, (ServerPlayer)player);
                    }
                });
            });
        }
    }
}

