/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record BackpackProperties(ResourceLocation model, boolean showWithElytra, boolean showEffects, boolean showEnchantmentGlint) {
    private final ResourceLocation model;
    public static final BackpackProperties DEFAULT = new BackpackProperties(null, false, true, false);
    public static final Codec<BackpackProperties> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(o -> o.model), (App)Codec.BOOL.fieldOf("show_with_elytra").forGetter(o -> o.showWithElytra), (App)Codec.BOOL.fieldOf("show_effects").forGetter(o -> o.showEffects), (App)Codec.BOOL.fieldOf("show_enchantment_glint").forGetter(o -> o.showEnchantmentGlint)).apply((Applicative)builder, BackpackProperties::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BackpackProperties> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, BackpackProperties::model, (StreamCodec)ByteBufCodecs.BOOL, BackpackProperties::showWithElytra, (StreamCodec)ByteBufCodecs.BOOL, BackpackProperties::showEffects, (StreamCodec)ByteBufCodecs.BOOL, BackpackProperties::showEnchantmentGlint, BackpackProperties::new);

    public ResourceLocation model() {
        if (this.model != null) {
            return this.model;
        }
        return BackpackManager.getDefaultOrFallbackCosmetic();
    }

    public BackpackProperties setModel(ResourceLocation model) {
        return new BackpackProperties(model, this.showWithElytra, this.showEffects, this.showEnchantmentGlint);
    }

    public BackpackProperties setShowWithElytra(boolean showWithElytra) {
        return new BackpackProperties(this.model, showWithElytra, this.showEffects, this.showEnchantmentGlint);
    }

    public BackpackProperties setShowEffects(boolean showEffects) {
        return new BackpackProperties(this.model, this.showWithElytra, showEffects, this.showEnchantmentGlint);
    }

    public BackpackProperties setShowEnchantmentGlint(boolean showEnchantmentGlint) {
        return new BackpackProperties(this.model, this.showWithElytra, this.showEffects, showEnchantmentGlint);
    }
}

