/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common;

import com.mrcrayfish.backpacked.core.ModEnchantments;
import com.mrcrayfish.backpacked.inventory.BackpackInventory;
import com.mrcrayfish.backpacked.inventory.BackpackedInventoryAccess;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.InventoryHelper;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.PlayerEvents;
import com.mrcrayfish.framework.event.IPlayerEvent;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EnchantmentHandler {
    public static void init() {
        PlayerEvents.PICKUP_EXPERIENCE.register((IFrameworkEvent)((IPlayerEvent.PickupExperience)EnchantmentHandler::onPickupExperience));
    }

    public static boolean onBreakBlock(BlockState state, ServerLevel level, BlockPos pos, @Nullable BlockEntity blockEntity, ServerPlayer player, ItemStack stack) {
        ItemStack backpack = Services.BACKPACK.getBackpackStack((Player)player);
        if (backpack.isEmpty()) {
            return false;
        }
        HolderLookup lookup = level.holderLookup(Registries.ENCHANTMENT);
        if (EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(ModEnchantments.FUNNELLING), (ItemStack)backpack) <= 0) {
            return false;
        }
        BackpackInventory inventory = ((BackpackedInventoryAccess)player).backpacked$GetBackpackInventory();
        if (inventory == null) {
            return false;
        }
        Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)stack).forEach(dropStack -> Block.popResource((Level)level, (BlockPos)pos, (ItemStack)inventory.addItem((ItemStack)dropStack)));
        state.spawnAfterBreak(level, pos, stack, true);
        return true;
    }

    public static boolean onDropLoot(Collection<ItemEntity> drops, DamageSource source) {
        Entity entity = source.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ItemStack backpack = Services.BACKPACK.getBackpackStack((Player)player);
        if (backpack.isEmpty()) {
            return false;
        }
        HolderLookup lookup = entity.level().holderLookup(Registries.ENCHANTMENT);
        if (EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(ModEnchantments.LOOTED), (ItemStack)backpack) <= 0) {
            return false;
        }
        BackpackInventory inventory = ((BackpackedInventoryAccess)player).backpacked$GetBackpackInventory();
        if (inventory == null) {
            return false;
        }
        drops.forEach(itemEntity -> {
            ItemStack stack = itemEntity.getItem();
            ItemStack remaining = inventory.addItem(stack);
            if (!remaining.isEmpty()) {
                itemEntity.setItem(remaining);
                player.level().addFreshEntity((Entity)itemEntity);
            }
        });
        return true;
    }

    public static boolean onPickupExperience(Player player, ExperienceOrb orb) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ItemStack backpack = Services.BACKPACK.getBackpackStack(player);
        if (backpack.isEmpty()) {
            return false;
        }
        HolderLookup lookup = player.level().holderLookup(Registries.ENCHANTMENT);
        if (EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(ModEnchantments.REPAIRMAN), (ItemStack)backpack) <= 0) {
            return false;
        }
        BackpackInventory inventory = ((BackpackedInventoryAccess)player).backpacked$GetBackpackInventory();
        if (inventory == null) {
            return false;
        }
        if (orb.isRemoved()) {
            return false;
        }
        InventoryHelper.streamFor((Container)inventory).filter(stack -> stack.isDamaged() && EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.REPAIR_WITH_XP)).forEach(stack -> {
            int repairableAmount = EnchantmentHelper.modifyDurabilityToRepairFromXp((ServerLevel)serverPlayer.serverLevel(), (ItemStack)stack, (int)orb.getValue());
            int maxRepairableDamage = Math.min(repairableAmount, stack.getDamageValue());
            stack.setDamageValue(stack.getDamageValue() - maxRepairableDamage);
        });
        return false;
    }
}

