/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.client.Keys;
import com.mrcrayfish.backpacked.common.backpack.BackpackProperties;
import com.mrcrayfish.backpacked.core.ModDataComponents;
import com.mrcrayfish.backpacked.data.pickpocket.TraderPickpocketing;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.api.event.ClientConnectionEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.InputEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IClientConnectionEvent;
import com.mrcrayfish.framework.event.IInputEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.Connection;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ClientEvents {
    public static void init() {
        TickEvents.END_CLIENT.register((IFrameworkEvent)((ITickEvent.EndClient)ClientEvents::onClientTickEnd));
        ClientConnectionEvents.LOGGING_IN.register((IFrameworkEvent)((IClientConnectionEvent.LoggingIn)ClientEvents::onPlayerLogin));
        InputEvents.KEY.register((IFrameworkEvent)((IInputEvent.Key)ClientEvents::onKeyInput));
        InputEvents.CLICK.register((IFrameworkEvent)((IInputEvent.Click)ClientEvents::onInteraction));
    }

    private static void onPlayerLogin(LocalPlayer player, MultiPlayerGameMode gameMode, Connection connection) {
        Config.updateBannedItemsList();
    }

    public static void onKeyInput(int key, int scanCode, int action, int modifiers) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null && mc.screen == null) {
            LocalPlayer player = mc.player;
            if (Keys.KEY_BACKPACK.isDown() && Keys.KEY_BACKPACK.consumeClick() && !Services.BACKPACK.getBackpackStack((Player)player).isEmpty()) {
                Network.getPlay().sendToServer((Object)new MessageOpenBackpack());
            }
        }
    }

    private static void onClientTickEnd() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        List players = mc.level.getEntities((EntityTypeTest)EntityType.PLAYER, mc.player.getBoundingBox().inflate(16.0), player -> true);
        for (Player player2 : players) {
            ItemStack stack;
            if (Services.BACKPACK.isBackpackVisible(player2) && !(stack = Services.BACKPACK.getBackpackStack(player2)).isEmpty() && ClientEvents.canShowBackpackEffects(stack)) continue;
        }
    }

    public static boolean canShowBackpackEffects(ItemStack stack) {
        return ((BackpackProperties)stack.getOrDefault((DataComponentType)ModDataComponents.BACKPACK_PROPERTIES.get(), (Object)BackpackProperties.DEFAULT)).showEffects();
    }

    private static boolean onInteraction(boolean attack, boolean use, boolean pick, InteractionHand hand) {
        if (!use || hand != InteractionHand.MAIN_HAND) {
            return false;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null || mc.gameMode == null) {
            return false;
        }
        double range = (Double)Config.SERVER.pickpocketing.maxReachDistance.get();
        ArrayList entities = new ArrayList();
        if (((Boolean)Config.SERVER.pickpocketing.enabled.get()).booleanValue()) {
            entities.addAll(mc.level.getEntities((EntityTypeTest)EntityType.PLAYER, mc.player.getBoundingBox().inflate(range), player -> !Services.BACKPACK.getBackpackStack((Player)player).isEmpty() && !player.equals((Object)mc.player) && PickpocketUtil.canPickpocketEntity((LivingEntity)player, (Player)mc.player)));
        }
        entities.addAll(mc.level.getEntities((EntityTypeTest)EntityType.WANDERING_TRADER, mc.player.getBoundingBox().inflate(mc.player.entityInteractionRange()), entity -> TraderPickpocketing.get((Entity)entity).map(TraderPickpocketing::isBackpackEquipped).orElse(false) != false && PickpocketUtil.canPickpocketEntity((LivingEntity)entity, (Player)mc.player, mc.player.entityInteractionRange())));
        if (entities.isEmpty()) {
            return false;
        }
        Vec3 start = mc.player.getEyePosition(1.0f);
        Vec3 end = mc.player.getViewVector(1.0f).scale(mc.player.entityInteractionRange()).add(start);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity hitEntity = null;
        for (LivingEntity entity2 : entities) {
            double distance;
            AABB box = PickpocketUtil.getBackpackBox(entity2, 1.0f);
            Optional optionalHitVec = box.clip(start, end);
            if (optionalHitVec.isEmpty() || !((distance = start.distanceTo((Vec3)optionalHitVec.get())) < closestDistance)) continue;
            closestDistance = distance;
            hitEntity = entity2;
        }
        if (hitEntity != null) {
            if (PickpocketUtil.canSeeBackpack(hitEntity, (Player)mc.player)) {
                Network.getPlay().sendToServer((Object)new MessageEntityBackpack(hitEntity.getId()));
                mc.player.swing(hand);
            }
            return true;
        }
        return false;
    }
}

