/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.blockentity;

import java.util.Optional;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface IOptionalStorage
extends Container {
    @Nullable
    public SimpleContainer getInventory();

    default public int getContainerSize() {
        return Optional.ofNullable(this.getInventory()).map(SimpleContainer::getContainerSize).orElse(0);
    }

    default public boolean isEmpty() {
        return Optional.ofNullable(this.getInventory()).map(SimpleContainer::isEmpty).orElse(true);
    }

    default public ItemStack getItem(int index) {
        return Optional.ofNullable(this.getInventory()).map(inv -> inv.getItem(index)).orElse(ItemStack.EMPTY);
    }

    default public ItemStack removeItem(int index, int count) {
        return Optional.ofNullable(this.getInventory()).map(inv -> inv.removeItem(index, count)).orElse(ItemStack.EMPTY);
    }

    default public ItemStack removeItemNoUpdate(int index) {
        return Optional.ofNullable(this.getInventory()).map(inv -> inv.removeItemNoUpdate(index)).orElse(ItemStack.EMPTY);
    }

    default public void setItem(int index, ItemStack stack) {
        Optional.ofNullable(this.getInventory()).ifPresent(inv -> inv.setItem(index, stack));
    }

    default public boolean stillValid(Player player) {
        return Optional.ofNullable(this.getInventory()).map(inv -> inv.stillValid(player)).orElse(false);
    }

    default public void clearContent() {
        Optional.ofNullable(this.getInventory()).ifPresent(SimpleContainer::clearContent);
    }

    default public boolean canPlaceItem(int index, ItemStack stack) {
        return this.getInventory() != null;
    }
}

