/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.items.packages;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BurstPackageItem
extends PackageItem {
    public BurstPackageItem(Item.Properties properties, PackageStyles.PackageStyle style) {
        super(properties, style);
        PackageStyles.ALL_BOXES.remove((Object)this);
        (style.rare() ? PackageStyles.RARE_BOXES : PackageStyles.STANDARD_BOXES).remove((Object)this);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.open(level, player, stack);
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        return InteractionResult.PASS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity entity, int ticks) {
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 0;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.NONE;
    }

    public void open(Level level, Player playerIn, ItemStack box) {
        ItemStackHandler contents = BurstPackageItem.getContents((ItemStack)box);
        ItemStack particle = box.copy();
        box.shrink(1);
        if (!level.isClientSide()) {
            for (int i = 0; i < contents.getSlots(); ++i) {
                ItemStack itemstack = contents.getStackInSlot(i);
                if (itemstack.isEmpty()) continue;
                Item item = itemstack.getItem();
                if (item instanceof SpawnEggItem) {
                    SpawnEggItem sei = (SpawnEggItem)item;
                    if (level instanceof ServerLevel) {
                        ServerLevel sl = (ServerLevel)level;
                        EntityType entitytype = sei.getType(itemstack);
                        Entity entity = entitytype.spawn(sl, itemstack, null, BlockPos.containing((Position)playerIn.position().add(playerIn.getLookAngle().multiply(1.0, 0.0, 1.0).normalize())), MobSpawnType.SPAWN_EGG, false, false);
                        if (entity != null) {
                            itemstack.shrink(1);
                        }
                    }
                }
                playerIn.getInventory().placeItemBackInInventory(itemstack.copy());
            }
        }
        Vec3 position = playerIn.position();
        AllSoundEvents.PACKAGE_POP.playOnServer(level, (Vec3i)playerIn.blockPosition());
        if (level.isClientSide()) {
            for (int i = 0; i < 10; ++i) {
                Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)level.getRandom(), (float)0.125f);
                Vec3 pos = position.add(0.0, 0.5, 0.0).add(playerIn.getLookAngle().scale(0.5)).add(motion.scale(4.0));
                level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, particle), pos.x, pos.y, pos.z, motion.x, motion.y, motion.z);
            }
        }
    }
}

