/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.fan_types;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.trains.CubeParticleData;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import dev.lopyluna.dndesires.register.DesiresRecipeTypes;
import dev.lopyluna.dndesires.register.DesiresTags;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class SeethingType
implements FanProcessingType {
    public boolean isValidAt(Level level, BlockPos pos) {
        FluidState fluidState = level.getFluidState(pos);
        if (DesiresTags.FluidTags.FAN_PROCESSING_CATALYSTS_SEETHING.is(fluidState)) {
            return true;
        }
        BlockState blockState = level.getBlockState(pos);
        if (DesiresTags.BlockTags.FAN_PROCESSING_CATALYSTS_SEETHING.is(blockState)) {
            return !blockState.hasProperty((Property)BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)blockState.getValue((Property)BlazeBurnerBlock.HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.SEETHING);
        }
        return false;
    }

    public int getPriority() {
        return 1200;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        return DesiresRecipeTypes.SEETHING.find(new SingleRecipeInput(stack), level).isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        return DesiresRecipeTypes.SEETHING.find(new SingleRecipeInput(stack), level).map(RecipeHolder::value).map(recipeRecipeHolder -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)recipeRecipeHolder, (boolean)true)).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(8) != 0) {
            return;
        }
        Vector3f color = new Color(1969981).asVectorF();
        level.addParticle((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, pos.x, pos.y + (double)0.45f, pos.z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        particleAccess.setColor(Color.mixColors((int)6605309, (int)4158696, (float)random.nextFloat()));
        particleAccess.setAlpha(1.0f);
        if (random.nextFloat() < 0.03125f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, 0.125f);
        }
        Vector3f colorBright = new Color(6605309).asVectorF();
        Vector3f colorDark = new Color(4158696).asVectorF();
        if (random.nextFloat() < 0.03125f) {
            particleAccess.spawnExtraParticle((ParticleOptions)new DustParticleOptions(colorBright, 1.0f), 0.125f);
        }
        if (random.nextFloat() < 0.03125f) {
            particleAccess.spawnExtraParticle((ParticleOptions)new DustParticleOptions(colorDark, 1.0f), 0.125f);
        }
        if (random.nextFloat() < 0.020833334f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.SMOKE, 0.125f);
        }
        if (random.nextFloat() < 0.03125f) {
            particleAccess.spawnExtraParticle((ParticleOptions)new CubeParticleData(192.0f, 122.0f, 85.0f, 0.075f, 10, true), 0.125f);
        }
        if (random.nextFloat() < 0.03125f) {
            particleAccess.spawnExtraParticle((ParticleOptions)new CubeParticleData(191.0f, 82.0f, 91.0f, 0.1f, 10, true), 0.125f);
        }
    }

    public void affectEntity(Entity entity, Level level) {
        if (entity instanceof Blaze) {
            Blaze blaze = (Blaze)entity;
            blaze.heal(2.0f);
        }
        if (!entity.fireImmune()) {
            entity.lavaHurt();
        }
    }
}

