/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.fan_types;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import dev.lopyluna.dndesires.register.DesiresRecipeTypes;
import dev.lopyluna.dndesires.register.DesiresTags;
import java.util.List;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.Nullable;

public class DragonBreathingType
implements FanProcessingType {
    public boolean isValidAt(Level level, BlockPos pos) {
        FluidState fluidState = level.getFluidState(pos);
        if (DesiresTags.FluidTags.FAN_PROCESSING_CATALYSTS_DRAGON_BREATHING.is(fluidState)) {
            return true;
        }
        BlockState blockState = level.getBlockState(pos);
        if (DesiresTags.BlockTags.FAN_PROCESSING_CATALYSTS_DRAGON_BREATHING.is(blockState)) {
            WallSkullBlock skullBlock;
            Block block = blockState.getBlock();
            if (block instanceof WallSkullBlock && (skullBlock = (WallSkullBlock)block) == Blocks.DRAGON_WALL_HEAD) {
                Direction skullFacing = (Direction)level.getBlockState(pos).getValue((Property)WallSkullBlock.FACING);
                BlockState fanState = level.getBlockState(pos.relative(skullFacing.getOpposite()));
                boolean powered = level.hasNeighborSignal(pos);
                boolean sameDirection = fanState.is(DesiresTags.BlockTags.FAN_CATALYSTS_DRAGON_SUPPORT.tag) && fanState.hasProperty((Property)BlockStateProperties.FACING) && fanState.getValue((Property)BlockStateProperties.FACING) == skullFacing;
                return powered && sameDirection;
            }
            return true;
        }
        return false;
    }

    public int getPriority() {
        return 1500;
    }

    public boolean canProcess(ItemStack stack, Level level) {
        return DesiresRecipeTypes.DRAGON_BREATHING.find(new SingleRecipeInput(stack), level).isPresent();
    }

    @Nullable
    public List<ItemStack> process(ItemStack stack, Level level) {
        return DesiresRecipeTypes.DRAGON_BREATHING.find(new SingleRecipeInput(stack), level).map(RecipeHolder::value).map(r -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)r, (boolean)true)).orElse(null);
    }

    public void spawnProcessingParticles(Level level, Vec3 pos) {
        if (level.random.nextInt(8) != 0) {
            return;
        }
        level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, pos.x + (double)((level.random.nextFloat() - 0.5f) * 0.5f), pos.y + 0.5, pos.z + (double)((level.random.nextFloat() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
    }

    public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
        particleAccess.setColor(Color.mixColors((int)13856729, (int)12721141, (float)random.nextFloat()));
        particleAccess.setAlpha(1.0f);
        if (random.nextFloat() < 0.0078125f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, 0.125f);
        }
        if (random.nextFloat() < 0.03125f) {
            particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.WITCH, 0.125f);
        }
    }

    public void affectEntity(Entity entity, Level level) {
        if (level.isClientSide) {
            return;
        }
        if (entity instanceof LivingEntity) {
            boolean flag1;
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.hurt(livingEntity.damageSources().dragonBreath(), 1.0f);
            RandomSource random = livingEntity.getRandom();
            double d0 = livingEntity.getX() + (random.nextDouble() - 0.5) * 32.0;
            double d1 = livingEntity.getY() + (double)(random.nextInt(32) - 16);
            double d2 = livingEntity.getZ() + (random.nextDouble() - 0.5) * 32.0;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(d0, d1, d2);
            while (pos.getY() > level.getMinBuildHeight() && !level.getBlockState((BlockPos)pos).blocksMotion()) {
                pos = pos.move(Direction.DOWN);
            }
            BlockState blockstate = level.getBlockState((BlockPos)pos);
            boolean flag = blockstate.blocksMotion();
            boolean bl = flag1 = !blockstate.getFluidState().is(FluidTags.WATER) && !blockstate.is(Blocks.COBWEB);
            if (flag && flag1) {
                EntityTeleportEvent.EnderEntity event = EventHooks.onEnderTeleport((LivingEntity)livingEntity, (double)d0, (double)d1, (double)d2);
                if (event.isCanceled()) {
                    return;
                }
                if (livingEntity.randomTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) {
                    level.gameEvent((Holder)GameEvent.TELEPORT, livingEntity.position(), GameEvent.Context.of((Entity)livingEntity));
                    if (!livingEntity.isSilent()) {
                        level.playSound(null, livingEntity.xo, livingEntity.yo, livingEntity.zo, SoundEvents.ENDERMAN_TELEPORT, livingEntity.getSoundSource(), 1.0f, 1.0f);
                        livingEntity.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                    }
                }
            }
        }
    }
}

