/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.logistics.roll_table;

import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.lopyluna.dndesires.content.blocks.logistics.roll_table.RollTableBE;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class RollTableItemHandler
implements IItemHandler {
    private final RollTableBE be;
    private final Direction side;

    public RollTableItemHandler(RollTableBE be, Direction side) {
        this.be = be;
        this.side = side;
    }

    public int getSlots() {
        return 1;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.be.getHeldItemStack();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.be.getHeldItemStack().isEmpty()) {
            return stack;
        }
        ItemStack returned = ItemHelper.limitCountToMaxStackSize((ItemStack)stack, (boolean)simulate);
        if (!simulate) {
            TransportedItemStack heldItem = new TransportedItemStack(stack);
            heldItem.prevBeltPosition = 0.0f;
            this.be.setHeldItem(heldItem, this.side.getOpposite());
            this.be.notifyUpdate();
        }
        return returned;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        TransportedItemStack held = this.be.heldItem;
        if (held == null) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = held.stack.copy();
        ItemStack extracted = stack.split(amount);
        if (!simulate) {
            this.be.heldItem.stack = stack;
            if (stack.isEmpty()) {
                this.be.heldItem = null;
            }
            this.be.notifyUpdate();
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }
}

