/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.omni_gearbox;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import dev.lopyluna.dndesires.content.blocks.kinetics.omni_gearbox.OmniGearboxBE;
import dev.lopyluna.dndesires.register.DesiresBETypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;

public class OmniGearboxBlock
extends KineticBlock
implements IBE<OmniGearboxBE> {
    public static final BooleanProperty UP_SHAFT = BooleanProperty.create((String)"top_shaft");
    public static final BooleanProperty DOWN_SHAFT = BooleanProperty.create((String)"bottom_shaft");
    public static final BooleanProperty NORTH_SHAFT = BooleanProperty.create((String)"north_shaft");
    public static final BooleanProperty EAST_SHAFT = BooleanProperty.create((String)"east_shaft");
    public static final BooleanProperty SOUTH_SHAFT = BooleanProperty.create((String)"south_shaft");
    public static final BooleanProperty WEST_SHAFT = BooleanProperty.create((String)"west_shaft");

    public OmniGearboxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP_SHAFT, (Comparable)Boolean.valueOf(true))).setValue((Property)DOWN_SHAFT, (Comparable)Boolean.valueOf(true))).setValue((Property)NORTH_SHAFT, (Comparable)Boolean.valueOf(true))).setValue((Property)EAST_SHAFT, (Comparable)Boolean.valueOf(true))).setValue((Property)SOUTH_SHAFT, (Comparable)Boolean.valueOf(true))).setValue((Property)WEST_SHAFT, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP_SHAFT, DOWN_SHAFT, NORTH_SHAFT, EAST_SHAFT, SOUTH_SHAFT, WEST_SHAFT});
    }

    public InteractionResult onWrenched(BlockState pState, UseOnContext pContext) {
        Level pLevel = pContext.getLevel();
        Direction clickedFace = pContext.getClickedFace();
        BlockState pStateNew = pState;
        BlockPos pClicked = pContext.getClickedPos();
        pStateNew = clickedFace == Direction.UP ? (BlockState)pStateNew.cycle((Property)UP_SHAFT) : pStateNew;
        pStateNew = clickedFace == Direction.DOWN ? (BlockState)pStateNew.cycle((Property)DOWN_SHAFT) : pStateNew;
        pStateNew = clickedFace == Direction.NORTH ? (BlockState)pStateNew.cycle((Property)NORTH_SHAFT) : pStateNew;
        pStateNew = clickedFace == Direction.EAST ? (BlockState)pStateNew.cycle((Property)EAST_SHAFT) : pStateNew;
        pStateNew = clickedFace == Direction.SOUTH ? (BlockState)pStateNew.cycle((Property)SOUTH_SHAFT) : pStateNew;
        pStateNew = clickedFace == Direction.WEST ? (BlockState)pStateNew.cycle((Property)WEST_SHAFT) : pStateNew;
        this.detachKinetics(pLevel, pClicked, true);
        KineticBlockEntity.switchToBlockState((Level)pLevel, (BlockPos)pClicked, (BlockState)this.updateAfterWrenched(pStateNew, pContext));
        if (pLevel.getBlockState(pClicked) != pState) {
            AllSoundEvents.WRENCH_ROTATE.playOnServer(pLevel, (Vec3i)pClicked, 1.0f, pLevel.random.nextFloat() + 0.5f);
        }
        return InteractionResult.SUCCESS;
    }

    public void detachKinetics(Level pLevel, BlockPos pPos, boolean reAttachNextTick) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (!(be instanceof KineticBlockEntity)) {
            return;
        }
        RotationPropagator.handleRemoved((Level)pLevel, (BlockPos)pPos, (KineticBlockEntity)((KineticBlockEntity)be));
        if (reAttachNextTick) {
            pLevel.scheduleTick(pPos, (Block)this, 1, TickPriority.EXTREMELY_HIGH);
        }
    }

    public void tick(@NotNull BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof KineticBlockEntity)) {
            return;
        }
        KineticBlockEntity kbe = (KineticBlockEntity)be;
        RotationPropagator.handleAdded((Level)level, (BlockPos)pos, (KineticBlockEntity)kbe);
    }

    public PushReaction getPistonPushReaction(@NotNull BlockState pState) {
        return PushReaction.PUSH_ONLY;
    }

    public Direction.Axis getRotationAxis(BlockState pState) {
        return Direction.Axis.Y;
    }

    @NotNull
    protected BlockState rotate(BlockState state, Rotation rotation) {
        Boolean NORTH = (Boolean)state.getValue((Property)NORTH_SHAFT);
        Boolean EAST = (Boolean)state.getValue((Property)EAST_SHAFT);
        Boolean SOUTH = (Boolean)state.getValue((Property)SOUTH_SHAFT);
        Boolean WEST = (Boolean)state.getValue((Property)WEST_SHAFT);
        return switch (rotation) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> state;
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH_SHAFT, (Comparable)WEST)).setValue((Property)SOUTH_SHAFT, (Comparable)EAST)).setValue((Property)EAST_SHAFT, (Comparable)NORTH)).setValue((Property)WEST_SHAFT, (Comparable)SOUTH);
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH_SHAFT, (Comparable)SOUTH)).setValue((Property)SOUTH_SHAFT, (Comparable)NORTH)).setValue((Property)EAST_SHAFT, (Comparable)WEST)).setValue((Property)WEST_SHAFT, (Comparable)EAST);
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH_SHAFT, (Comparable)EAST)).setValue((Property)SOUTH_SHAFT, (Comparable)WEST)).setValue((Property)EAST_SHAFT, (Comparable)SOUTH)).setValue((Property)WEST_SHAFT, (Comparable)NORTH);
        };
    }

    @NotNull
    protected BlockState mirror(@NotNull BlockState state, Mirror mirror) {
        return switch (mirror) {
            default -> throw new MatchException(null, null);
            case Mirror.NONE -> state;
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue((Property)NORTH_SHAFT, (Comparable)((Boolean)state.getValue((Property)SOUTH_SHAFT)))).setValue((Property)SOUTH_SHAFT, (Comparable)((Boolean)state.getValue((Property)NORTH_SHAFT)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue((Property)EAST_SHAFT, (Comparable)((Boolean)state.getValue((Property)WEST_SHAFT)))).setValue((Property)WEST_SHAFT, (Comparable)((Boolean)state.getValue((Property)EAST_SHAFT)));
        };
    }

    public boolean hasShaftTowards(LevelReader pLevel, BlockPos pPos, BlockState pState, Direction pFace) {
        return pFace == Direction.UP && (Boolean)pState.getValue((Property)UP_SHAFT) != false || pFace == Direction.DOWN && (Boolean)pState.getValue((Property)DOWN_SHAFT) != false || pFace == Direction.NORTH && (Boolean)pState.getValue((Property)NORTH_SHAFT) != false || pFace == Direction.EAST && (Boolean)pState.getValue((Property)EAST_SHAFT) != false || pFace == Direction.SOUTH && (Boolean)pState.getValue((Property)SOUTH_SHAFT) != false || pFace == Direction.WEST && (Boolean)pState.getValue((Property)WEST_SHAFT) != false;
    }

    public Class<OmniGearboxBE> getBlockEntityClass() {
        return OmniGearboxBE.class;
    }

    public BlockEntityType<? extends OmniGearboxBE> getBlockEntityType() {
        return (BlockEntityType)DesiresBETypes.GEARBOX.get();
    }
}

