/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blockEntities.visuals;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import fr.iglee42.createcasing.blocks.customs.EncasedCustomCogwheelBlock;
import fr.iglee42.createcasing.registries.EncasedPartialModels;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class EncasedCustomCogVisual
extends KineticBlockEntityVisual<KineticBlockEntity> {
    private final boolean large;
    protected RotatingInstance rotatingModel;
    protected RotatingInstance rotatingTopShaft;
    protected RotatingInstance rotatingBottomShaft;

    public static EncasedCustomCogVisual small(VisualizationContext modelManager, KineticBlockEntity blockEntity, float partialTick) {
        return new EncasedCustomCogVisual(modelManager, blockEntity, false, partialTick, Models.partial((PartialModel)EncasedCustomCogVisual.getCogModel((BlockEntity)blockEntity, false)));
    }

    public static EncasedCustomCogVisual large(VisualizationContext modelManager, KineticBlockEntity blockEntity, float partialTick) {
        return new EncasedCustomCogVisual(modelManager, blockEntity, true, partialTick, Models.partial((PartialModel)EncasedCustomCogVisual.getCogModel((BlockEntity)blockEntity, true)));
    }

    public EncasedCustomCogVisual(VisualizationContext modelManager, KineticBlockEntity blockEntity, boolean large, float partialTick, Model model) {
        super(modelManager, blockEntity, partialTick);
        this.large = large;
        this.rotatingModel = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, model).createInstance();
        this.rotatingModel.setup(blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(this.rotationAxis()).setChanged();
        RotatingInstance rotatingTopShaft = null;
        RotatingInstance rotatingBottomShaft = null;
        Block block = this.blockState.getBlock();
        if (block instanceof IRotate) {
            IRotate def = (IRotate)block;
            for (Direction d : Iterate.directionsInAxis((Direction.Axis)this.rotationAxis())) {
                if (!def.hasShaftTowards((LevelReader)blockEntity.getLevel(), blockEntity.getBlockPos(), this.blockState, d)) continue;
                RotatingInstance instance = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance();
                instance.setup(blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, d).setChanged();
                if (large) {
                    instance.setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)this.rotationAxis(), (BlockPos)this.pos));
                }
                if (d.getAxisDirection() == Direction.AxisDirection.POSITIVE) {
                    rotatingTopShaft = instance;
                    continue;
                }
                rotatingBottomShaft = instance;
            }
        }
        this.rotatingTopShaft = rotatingTopShaft;
        this.rotatingBottomShaft = rotatingBottomShaft;
    }

    public void update(float pt) {
        this.rotatingModel.setup((KineticBlockEntity)this.blockEntity).setChanged();
        if (this.rotatingTopShaft != null) {
            this.rotatingTopShaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
        if (this.rotatingBottomShaft != null) {
            this.rotatingBottomShaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
        }
    }

    public void updateLight(float partialTick) {
        this.relight(new FlatLit[]{this.rotatingModel, this.rotatingTopShaft, this.rotatingBottomShaft});
    }

    protected void _delete() {
        this.rotatingModel.delete();
        if (this.rotatingTopShaft != null) {
            this.rotatingTopShaft.delete();
        }
        if (this.rotatingBottomShaft != null) {
            this.rotatingBottomShaft.delete();
        }
    }

    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
        consumer.accept((Instance)this.rotatingModel);
        consumer.accept((Instance)this.rotatingTopShaft);
        consumer.accept((Instance)this.rotatingBottomShaft);
    }

    protected static PartialModel getCogModel(BlockEntity blockEntity, boolean large) {
        BlockState referenceState = blockEntity.getBlockState();
        Direction facing = Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)referenceState.getValue((Property)BlockStateProperties.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        PartialModel partial = large ? EncasedPartialModels.SHAFTLESS_LARGE_COGS_MODELS.get(BuiltInRegistries.BLOCK.getKey((Object)((EncasedCustomCogwheelBlock)referenceState.getBlock()).getCogwheel().get()).getPath().replaceAll("_large_cogwheel", "")) : EncasedPartialModels.SHAFTLESS_COGS_MODELS.get(BuiltInRegistries.BLOCK.getKey((Object)((EncasedCustomCogwheelBlock)referenceState.getBlock()).getCogwheel().get()).getPath().replaceAll("_cogwheel", ""));
        return partial;
    }
}

